<?php

declare(strict_types=1);

namespace popp\r04\zestaw12;

/* listing 04.73 */
class Runner
{
/* /listing 04.73 */
    public static function run()
    {
        return Runner::init();
    }

/* listing 04.73 */
    public static function init()
    {
        try {
            $conf = new Conf(__DIR__ . "/conf.broken.xml");
            print "user: " . $conf->get('user') . "\n";
            print "host: " . $conf->get('host') . "\n";
            $conf->set("pass", "newpass");
            $conf->write();
        } catch (FileException $e) {
            // błąd uprawnień lub brak pliku
            throw $e;
        } catch (XmlException $e) {
/* /listing 04.73 */
            return "wyjątek xml";
/* listing 04.73 */
            // wadliwy XML
        } catch (ConfException $e) {
            // zły rodzaj pliku XML
        } catch (\Exception $e) {
            // zabezpieczenie: nie powinno dojść do tego wywołania
        }
    }
}
/* /listing 04.73 */
