<?php

declare(strict_types=1);

namespace popp\r04\zestaw05;

use popp\r04\zestaw02\CdProduct;
use popp\r04\zestaw02\ShopProduct;
use popp\r04\zestaw05\ShopProduct as LocalShopProduct;

class Runner
{
    public static function run()
    {
        $product = new LocalShopProduct(12.22);
        return $product->getPrice();
    }

    public static function run2()
    {
        $consultancy = new Consultancy();
        print $consultancy->getPrice();
    }


/* listing 04.17 */
    public function cdInfo(CdProduct $prod): int
    {
        // wiemy, że możemy odwołać się do metody getPlayLength()
        $length = $prod->getPlayLength();
        // ...
/* /listing 04.17 */
        return $length;
/* listing 04.17 */
    }
/* /listing 04.17 */

/* listing 04.18 */
    public function addProduct(ShopProduct $prod)
    {
    // nawet jeśli $prod jest obiektem klasy CdProduct
    // nie wiemy tego na pewno, nie możemy więc
    // zakładać, że wolno nam użyć metody getPlayLength()
    // ... 
/* /listing 04.18 */
        return $prod->getSummaryLine();
/* listing 04.18 */
    }
/* /listing 04.18 */

/* listing 04.19 */
    public function addChargeableItem(Chargeable $item)
    {
    // o argumencie $item wiadomo jedynie tyle, że jest
    // obiektem Chargeable, ale fakt, że jest on też
    // obiektem CdProduct nie ma tu znaczenia.
    // Możemy być pewni jedynie istnienia metody getPrice()
    //
    //...
/* /listing 04.19 */
        return $item->getPrice();
/* listing 04.19 */
    }
/* /listing 04.19 */
}
