<?php
declare(strict_types=1);

namespace popp\r05\zestaw04;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch04Test extends BaseUnit 
{

    /*
    // usuń komentarz, aby wywołać błąd krytyczny - konflikt przestrzeni nazw
    public function testClash()
    {
        //require_once("src/r05/zestaw04/clash.php");
    }
    */

    public function testRunner()
    {
        // /////////////////////////////////////////////////////////////////////

        $val = $this->capture(function() { Runner::runbefore(); });
        $expected = <<<EXPECTED
pozdrowienia od popp\r05\zestaw04\Debug

EXPECTED;
        self::assertEquals($expected, $val);

        // /////////////////////////////////////////////////////////////////////

        $val = $this->capture(function() { Runner::run(); });
        $expected = <<<EXPECTED
pozdrowienia od Debug

EXPECTED;

        self::assertEquals($expected, $val);

        // /////////////////////////////////////////////////////////////////////

        $val = $this->capture(function() { Runner::run2(); });
        $expected = <<<EXPECTED
pozdrowienia od Debug

EXPECTED;

        self::assertEquals($expected, $val);

        // /////////////////////////////////////////////////////////////////////

        $val = $this->capture(function() { Runner::run3(); });
        $expected = <<<EXPECTED
pozdrowienia od Debug

EXPECTED;

        self::assertEquals($expected, $val);

        // /////////////////////////////////////////////////////////////////////

        $val = $this->capture(function() { Runner::run4(); });
        $expected = <<<EXPECTED
pozdrowienia od Debug

EXPECTED;
        self::assertEquals($expected, $val);

        // /////////////////////////////////////////////////////////////////////

        $val = $this->capture(function() { Runner::run5(); });
        $expected = <<<EXPECTED
pozdrowienia od popp\r05\zestaw04\Debug

EXPECTED;

        self::assertEquals($expected, $val);

        // /////////////////////////////////////////////////////////////////////

        $val = $this->capture(function() { Runner::run8(); });
        self::assertEquals("Ahoj z katalogu głównego!", $val);

        $val = $this->capture(function() { Runner::run9(); });
        self::assertEquals("Ahoj z pliku z podkreśleniami!", $val);




        $val = $this->capture(function() { Runner::run10(); });
        self::assertEquals("pozdrowienia od util\\LocalPath", $val);

        $val = $this->capture(function() { Runner::run10_2(); });
        self::assertEquals("pozdrowienia od util\\LocalPath", $val);

        $val = $this->capture(function() { Runner::run11(); });
        $expected = "Ahoj z pliku z podkreśleniami!pozdrowienia od util\\LocalPath";
        self::assertEquals($expected, $val);
    }

    public function testUnClash()
    {
        $val = $this->capture(function() { 
            require_once("src/r05/zestaw04/unclash.php");
        });
        self::assertEquals("pozdrowienia od popp\r05\zestaw04\Debug\n", $val);
    }

    public function testMulti()
    {
        $val = $this->capture(function() { 
            require_once("src/r05/zestaw04/Multi.php");
        });
        self::assertEquals("pozdrowienia od Debug\n", $val);
    }


    public function testMain()
    {
        // wymuszenie dołączenia
        $val = $this->capture(function() { Runner::runbefore(); });

        self::expectException(\Error::class);
        \main\mainrun1();
    }

    public function testMain2()
    {
        // wymuszenie dołączenia
        $val = $this->capture(function() { Runner::runbefore(); });

        $val = $this->capture(function() { \main\mainrun2(); });
        $expected = <<<EXPECTED
pozdrowienia od popp\r05\zestaw04\Debug

EXPECTED;

        self::assertEquals($expected, $val);
    }

    public function testMain3()
    {
        // wymuszenie dołączenia
        $val = $this->capture(function() { Runner::runbefore(); });

        $val = $this->capture(function() { \main\mainrun3(); });
        $expected = <<<EXPECTED
pozdrowienia od Debug

EXPECTED;

        self::assertEquals($expected, $val);
    }

    public function testMain4()
    {
        // wymuszenie dołączenia
        $val = $this->capture(function() { Runner::runbefore(); });

        $val = $this->capture(function() { \main\mainrun4(); });
        $expected = <<<EXPECTED
pozdrowienia od Debug

EXPECTED;

        self::assertEquals($expected, $val);
    }


    public function testRunner7()
    {
        $val = $this->capture(function() { Runner::run7(); });
        $expected = <<<EXPECTED
pozdrowienia od popp\r05\zestaw04\util
pozdrowienia od root namespace

EXPECTED;

        self::assertEquals($expected, $val);
    }

    public function testRunRequires()
    {
        $val = $this->capture(function() { Runner::runRequires(); });
        self::assertEquals("CustomerWebToolsUser", $val);
    }
}
