<?php
declare(strict_types=1);

namespace popp\r04\zestaw08;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;

class Batch08Test extends BaseUnit 
{

    public function testRunner()
    {

        $val = $this->capture(function() { Runner::run3(); });
        $expected = <<<EXPECTED
buty: przetwarzanie sprzedaży 
    wysyłka (buty)

kawa: przetwarzanie sprzedaży 
    wysyłka (kawa)

EXPECTED;
        self::assertEquals($expected, $val);
    }

    public function testRunnerTotalizer()
    {

        $val = $this->capture(function() { Runner::run4(); });
        $expected = <<<EXPECTED
buty: przetwarzanie sprzedaży 
    drogo: 6

kawa: przetwarzanie sprzedaży 
    drogo: 6

EXPECTED;
        self::assertEquals($expected, $val);

    }

    public function testRunnerTotalizerClosure()
    {

        $val = $this->capture(function() { Runner::run5(); });
        $expected = <<<EXPECTED
buty: przetwarzanie sprzedaży 
   suma: 6

kawa: przetwarzanie sprzedaży 
   suma: 12
   drogo: 12

EXPECTED;
        self::assertEquals($expected, $val);
    }

    public function testRunnerTotalizerClosureFromCallable()
    {
        $val = $this->capture(function() { Runner::run6(); });
        $expected = <<<EXPECTED
buty: przetwarzanie sprzedaży 
   suma: 6

kawa: przetwarzanie sprzedaży 
   suma: 12
   drogo: 12

EXPECTED;
        self::assertEquals($expected, $val);

    }
    
    public function testRunnerArrowFunctionClosure()
    {
        $val = $this->capture(function() { Runner::run7(); });
        //print $val."\n";
        $expected = <<<EXPECTED
buty: przetwarzanie sprzedaży 
(buty) cena z narzutem: 9

kawa: przetwarzanie sprzedaży 
(kawa) cena z narzutem: 9

EXPECTED;
        self::assertEquals($expected, $val);
    }
}

