<?php

namespace popp\r03;

require_once("vendor/autoload.php");
use PHPUnit\Framework\TestCase;

use popp\r03\zestaw07\AddressManager;

// nie ma potrzeby tworzenia kopii
use popp\r03\zestaw04\ShopProduct;
use popp\r03\zestaw07\ShopProductWriter;
use popp\r03\zestaw07\Runner;

class Batch07Test extends TestCase
{
    public function testAddressManager()
    {
        $aman = new AddressManager();
        self::assertTrue($aman instanceof AddressManager);
    }

    public function testProductWriter()
    {
        
        $product = new ShopProduct("title", "first", "main", 99);
        self::assertTrue($product instanceof ShopProduct);
        self::assertEquals($product->title, "title");
        self::assertEquals($product->producerFirstName, "first");
        self::assertEquals($product->producerMainName, "main");
        self::assertEquals($product->price, 99);
        $spw = new ShopProductWriter();

        ob_start();
        $spw->write($product);
        $output1 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("title: first main (99)\n", $output1);
       
        ob_start();
        Runner::run1();
        $output2 = ob_get_contents();
        ob_end_clean();
        self::assertEquals("Moja Antonia: Willa Cather (5.99)\n", $output2);

    }
}
