<?php

declare(strict_types=1);

namespace popp\r13\zestaw03;

use popp\r12\zestaw10\TableCreator;
use popp\r12\zestaw06\Conf;
use popp\r13\zestaw01\Registry;
use popp\r13\zestaw01\Venue;

class Runner
{
    public static function run()
    {
        self::setUp();

// bezpośrednia konkretyzacja - w przeciwnym razie dostaniemy zestaw01

/* listing 13.20 */
        $mapper = new VenueMapper();

        $venue = new Venue(-1, "Pod Pełnym Kuflem");
        $mapper->insert($venue);

        $venue1 = $mapper->find($venue->getId());
        $venue2 = $mapper->find($venue->getId());

        $venue1->setName("Pod Inną Nazwą");
        $venue2->setName("Pod Kuflem Pełnym Piwa");

        print $venue->getName() . "\n";
        print $venue1->getName() . "\n";
        print $venue2->getName() . "\n";
/* /listing 13.20 */
    }

    public static function run2()
    {
        self::setUp();

        // bezpośrednia konkretyzacja - w przeciwnym razie dostaniemy zestaw01
        $mapper = new VenueMapper();

        $venue = new Venue(-1, "Pod Pełnym Kuflem");
        $mapper->insert($venue);
        $venue = $mapper->find($venue->getId());
        $venue->setName("Pod Kuflem Pełnym Piwa");

        // jeszcze tego nie zapisaliśmy... co jeśli pobierzemy
        // wartość z innego miejsca?
        $mapper2 = new VenueMapper();
        $venue2 = $mapper2->find($venue->getId());
        print $venue2->getName() . "\n";
    }

    private static function setUp()
    {
        $config = __DIR__ . "/../batch01/data/woo_options.ini";
        $options = parse_ini_file($config, true);
        Registry::reset();
        $reg = Registry::instance();
        $conf = new Conf($options['config']);
        $reg->setConf($conf);
        $reg = Registry::instance();
        $dsn = $reg->getDSN();

        if (is_null($dsn)) {
            throw new AppException("No DSN");
        }

        $pdo = new \PDO($dsn);
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        $autoincrement = "AUTOINCREMENT";

        $pdo->query("DROP TABLE IF EXISTS venue");
        $pdo->query("CREATE TABLE venue ( id INTEGER PRIMARY KEY
            $autoincrement, name TEXT )");
        $pdo->query("INSERT into venue ( name ) values ('bob')");
        $pdo->query("DROP TABLE  IF EXISTS space");
        $pdo->query("CREATE TABLE space ( id INTEGER PRIMARY KEY
            $autoincrement, venue INTEGER, name TEXT )");
        $pdo->query("DROP TABLE IF EXISTS event");
        $pdo->query("CREATE TABLE event ( id INTEGER PRIMARY KEY
            $autoincrement, space INTEGER, start long, duration int, name text )");
    }
}
