<?php
declare(strict_types=1);

namespace popp\r13\zestaw01;

// autoload won't help us here -- since Runner has a sneaky sub namespace
require_once(__DIR__."/../../src/r13/zestaw01/Runner.php");
require_once("vendor/autoload.php");

use popp\test\BaseUnit;
use popp\r13\zestaw01\sub\FakeMapper;

class Batch01Test extends BaseUnit 
{

    public function testVenueMapper()
    {
        $val = $this->capture(function() { Runner::run(); });
        self::assertMatchesRegularExpression("/Venue Object/", $val);
        self::assertMatchesRegularExpression("/Pod Pełnym Kuflem/", $val);
    } 

    public function testVenueMapper2()
    {

        $val = $this->capture(function() { Runner::run2(); });
        self::assertMatchesRegularExpression("/Venue Object/", $val);
        self::assertMatchesRegularExpression("/Pod Pełnym Kuflem/", $val);
        self::assertMatchesRegularExpression("/Pod Kuflem Pełnym Piwa/", $val);

    }

    public function testIterator()
    {
        $val = $this->capture(function() { Runner::run3(); });
        $str = "Szalony Parkiet\nEeezy\nU Kaczki i Borsuka\n";
        self::assertEquals($str, $val);
    }

    public function testGenCollection()
    {
       
        $val = $this->capture(function() { Runner::run4(); });

        self::assertMatchesRegularExpression("/Szalony Parkiet/", $val);
        self::assertMatchesRegularExpression("/Pełny Luz/", $val);
        self::assertMatchesRegularExpression("/U Kaczki i Borsuka/", $val);
    }

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run5(); });
        self::assertMatchesRegularExpression("/Wielka scena/", $val);
        self::assertMatchesRegularExpression("/Suterena/", $val);
    }

    public function testFakeMapper()
    {
        $dsn = "sqlite:/var/popp/src/r13/zestaw01/data/woo.db";
        $pdo = new \PDO($dsn);
        $mapper = new FakeMapper($pdo);
        self::assertTrue($mapper instanceof FakeMapper);
    }
}
