<?php
declare(strict_types=1);

namespace popp\r09\zestaw14;

use popp\r09\zestaw06\BloggsApptEncoder;
use popp\r09\zestaw11\TerrainFactory;


require_once("vendor/autoload.php");

use popp\test\BaseUnit;

use popp\r09\zestaw11\EarthSea;
use popp\r09\zestaw11\MarsPlains;
use popp\r09\zestaw11\Forest;
use popp\r09\zestaw11\EarthForest;

class Batch14Test extends BaseUnit
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        //print $val;
        self::assertEquals($val, "Dane spotkania zakodowane w formacie BloggsCal\n");
        
    }

    public function testAssembler()
    {
        $assembler = new ObjectAssembler("src/r09/zestaw14/objects.xml");
        $component = $assembler->getComponent(TerrainFactory::class);

        self::assertTrue($component->getSea() instanceof EarthSea);
        self::assertTrue($component->getPlains() instanceof MarsPlains);
        self::assertTrue($component->getForest() instanceof EarthForest);

        $apptmaker = $assembler->getComponent(AppointmentMaker2::class);
        $out = $apptmaker->makeAppointment();
        self::assertEquals($out, "Dane spotkania zakodowane w formacie BloggsCal\n");
    }


    public function testNaiveEncoder()
    {
        $apptmaker = new AppointmentMaker();
        $out = $apptmaker->makeAppointment();
        self::assertEquals($out, "Dane spotkania zakodowane w formacie BloggsCal\n");
    }

    public function testLessNaiveEncoder()
    {
        $apptmaker = new AppointmentMaker2(new BloggsApptEncoder());
        $out = $apptmaker->makeAppointment();
        self::assertEquals($out, "Dane spotkania zakodowane w formacie BloggsCal\n");
    }
}
