<?php

declare(strict_types=1);

namespace popp\r11\zestaw09\commands;

use popp\r11\zestaw09\CommandContext;
use popp\r11\zestaw09\Command;
use popp\r11\zestaw09\Registry;

/* listing 11.49 */
class LoginCommand extends Command
{

    public function execute(CommandContext $context): bool
    {
        $manager = Registry::getAccessManager();
        $user = $context->get('username');
        $pass = $context->get('pass');
        $user_obj = $manager->login($user, $pass);

        if (is_null($user_obj)) {
            $context->setError($manager->getError());
            return false;
        }

        $context->addParam("user", $user_obj);

        return true;
    }
}
