<?php

declare(strict_types=1);

namespace popp\r09\zestaw13;

use popp\r09\zestaw09\CommsManager;
use popp\r09\zestaw09\MegaCommsManager;
use popp\r09\zestaw09\BloggsCommsManager;

/* listing 09.49 */
class AppConfig
{
    private static ?AppConfig $instance = null;
    private CommsManager $commsManager;

    private function __construct()
    {
        // wywoływana tylko raz
        $this->init();
    }

    private function init(): void
    {
        switch (Settings::$COMMSTYPE) {
            case 'Mega':
                $this->commsManager = new MegaCommsManager();
                break;
            default:
                $this->commsManager = new BloggsCommsManager();
        }
    }

    public static function getInstance(): AppConfig
    {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function getCommsManager(): CommsManager
    {
        return $this->commsManager;
    }
}
