<?php
declare(strict_types=1);

namespace popp\r09\zestaw15;

use popp\r09\zestaw06\BloggsApptEncoder;

require_once("vendor/autoload.php");

use popp\test\BaseUnit;
use popp\r09\zestaw11\Sea;
use popp\r09\zestaw11\Plains;
use popp\r09\zestaw11\Forest;

use popp\r09\zestaw11\EarthSea;
use popp\r09\zestaw11\EarthPlains;
use popp\r09\zestaw11\MarsPlains;
use popp\r09\zestaw11\EarthForest;
use popp\r09\zestaw11\MarsForest;

class Batch15Test extends BaseUnit
{

    public function testRunner()
    {
        $val = $this->capture(function() { Runner::run(); });
        //print $val;
        self::assertEquals($val, "Dane spotkania zakodowane w formacie BloggsCal\n");
        
    }

    public function testNonArgInjection()
    {
        $assembler = new ObjectAssembler("src/r09/zestaw15/objects.xml");
        $apptmaker = $assembler->getComponent(AppointmentMaker::class);
        self::assertTrue($apptmaker instanceof AppointmentMaker);
    }

    public function testNoArgsDefinedInstance()
    {
        $assembler = new ObjectAssembler("src/r09/zestaw15/objects.xml");
        $sea = $assembler->getComponent(Sea::class);
        self::assertTrue($sea instanceof EarthSea);

        $plains = $assembler->getComponent(Plains::class);
        self::assertTrue($plains instanceof MarsPlains);

        $forest = $assembler->getComponent(Forest::class);
        self::assertTrue($forest instanceof EarthForest);
    }

    public function testAttributeConstructor()
    {
        $assembler = new ObjectAssembler("src/r09/zestaw15/objects.xml");
        $terrainfactory = $assembler->getComponent(TerrainFactory::class);
        self::assertTrue($terrainfactory->getSea() instanceof EarthSea);
        self::assertTrue($terrainfactory->getPlains() instanceof MarsPlains);
        self::assertTrue($terrainfactory->getForest() instanceof EarthForest);
    }

    public function testAttributeSetter()
    {
        $assembler = new ObjectAssembler("src/r09/zestaw15/objects.xml");
        $apptmaker = $assembler->getComponent(AppointmentMaker::class);
        $output = $apptmaker->makeAppointment();
        self::assertEquals("Dane spotkania zakodowane w formacie BloggsCal\n", $output);
    }

    public function testAttributeSetterRunner()
    {
        $val = $this->capture(function() { Runner::run3(); });
        //print $val;
        self::assertEquals("Dane spotkania zakodowane w formacie BloggsCal\n", $val);
    }

    public function testDefinedNoArgsNoInstance()
    {
        $assembler = new ObjectAssembler("src/r09/zestaw15/objects.xml");
        $apptmaker = $assembler->getComponent(AppointmentMaker2::class);
        $out = $apptmaker->makeAppointment();
        self::assertEquals($out, "Dane spotkania zakodowane w formacie BloggsCal\n");
    }


}
