<?php

declare(strict_types=1);

namespace popp\r18\zestaw03;

use PHPUnit\Framework\TestCase;

class UserStoreTest extends TestCase
{
    private UserStore $store;

    protected function setUp(): void
    {
        $this->store = new UserStore();
    }

    public function testAddUserShortPass2(): void
    {
        try {
            $this->store->addUser("bob williams", "bob@example.com", "ff");
            $this->assertEquals("bob williams", $this->store->getUser()['name']);
        } catch (\Exception $e) {
            $this->assertEquals("Hasło musi mieć co najmniej 5 liter", $e->getMessage());
            return;
        }

        $this->fail("Oczekiwany wyjątek dotyczący zbyt krótkiego hasła");
    }

    public function testAddUserShortPass(): void
    {
        $this->expectException('\\Exception');
        $this->store->addUser("bob williams", "a@b.com", "ff");
        $this->fail("Oczekiwany wyjątek dotyczący zbyt krótkiego hasła");
    }

    public function testAddUserDuplicate(): void
    {
        try {
            $ret = $this->store->addUser("bob williams", "a@b.com", "123456");
            $ret = $this->store->addUser("bob stevens", "a@b.com", "123456");
            self::fail("Oczekiwany wyjątek");
        } catch (\Exception $e) {
            $const = $this->logicalAnd(
                //$this->logicalNot( $this->contains("bob stevens")),
                $this->isType('object')
            );
            self::AssertThat($this->store->getUser("a@b.com"), $const);
        }
    }

// UserStoreTest

/* listing 18.19 */
    public function testGetUser(): void
    {
        $this->store->addUser("bob williams", "a@b.com", "12345");
        $user = $this->store->getUser("a@b.com");
        $this->assertEquals($user->getMail(), "a@b.com");
    }
/* /listing 18.19 */
}
