<?php

declare(strict_types=1);

namespace popp\r12\zestaw08;

use popp\r12\zestaw06\Registry;
use popp\r12\zestaw06\Request;
use popp\r12\zestaw06\HttpRequest;
use popp\r12\zestaw08\CliRequest;

/* listing 12.35 */
abstract class PageController
{
    private Registry $reg;

    abstract public function process(): void;

    public function __construct()
    {
        $this->reg = Registry::instance();
    }

    public function init(): void
    {
        if (isset($_SERVER['REQUEST_METHOD'])) {
            $request = new HttpRequest();
        } else {
            $request = new CliRequest();
        }

        $this->reg->setRequest($request);
    }

    public function forward(string $resource): void
    {
        $request = $this->getRequest();
        $request->forward($resource);
    }

    public function render(string $resource, Request $request): void
    {
        include($resource);
    }

    public function getRequest(): Request
    {
        return $this->reg->getRequest();
    }
}
/* /listing 12.35 */
