<?php

declare(strict_types=1);

namespace popp\r03\zestaw14;

use popp\r03\zestaw14\ShopProduct;

class CdProduct extends ShopProduct
{
    public int $playLength;

    public function __construct(
        string $title,
        string $firstName,
        string $mainName,
        float $price,
        int $playLength
    ) {
        parent::__construct(
            $title,
            $firstName,
            $mainName,
            $price
        );
        $this->playLength = $playLength;
    }

    public function getPlayLength(): int
    {
        return $this->playLength;
    }

    public function getSummaryLine(): string
    {
        $base  = "{$this->title} ( {$this->producerMainName}, ";
        $base .= "{$this->producerFirstName} )";
        $base .= ": czas nagrania - {$this->playLength}";
        return $base;
    }
}
