# PHP. Obiekty, wzorce i narzędzia

## Kod źródłowy

Ten katalog zawiera kod źródłowy do książki "PHP. Obiekty, wzorce i narzędzia" oraz kilka dość podstawowych testów.

### Uruchamianie testów

Aby uruchomić testy, należy zainstalować PHPUnit. Najłatwiej to zrobić, używając instrukcji `composer` (Pliki `composer.json` i `composer.lock` zostały umieszczone w tym archiwum). 
    
    `\`$ composer install    
    \`  
    `

Program PHPUnit zostanie zainstalowany na lokalnym komputerze. Polecenie to spowoduje też skonfigurowanie automatycznego ładowania klas. Następnie można uruchomić testy: 
    
    `\`./vendor/bin/phpunit test/    
    \`  
    `

### Wyszukiwanie przykładów

W książce przykłady kodu są często przedstawiane we fragmentarycznej formie lub z pominięciem szczegółów. W przypadku tych plików tak nie jest. Poszczególne przykłady są oznaczane w kodzie wykonywalnym za pomocą komentarzy. Na przykład poniżej został zamieszczony fragment z pliku src/r13/zestaw01/SpaceMapper.php, który zawiera przykłady kodu 13.16 i 13.17\. Ta sztuczka pozwala mi testować jednostkowo przykłady. Do generowania i łączenia przykładów użyłem własnych narzędzi.   

    `\`<?php    
      
    declare(strict_types=1);    
      
    namespace popp\r13\zestaw01;    
      
    class SpaceMapper extends Mapper    
    {    
      
    // ...    
      
    /* listing 13.16 */    
      
    // SpaceMapper::__construct()    
      
    $this->selectAllStmt = $this->pdo->prepare(    
    "SELECT * FROM space"    
    );    
    $this->findByVenueStmt = $this->pdo->prepare(    
    "SELECT * FROM space WHERE venue=?"    
    );    
    /* /listing 13.16 */    
    }    
      
    /* listing 13.17 */    
    public function getCollection(array $raw): SpaceCollection    
    {    
    return new SpaceCollection($raw, $this);    
    }    
    /* /listing 13.17 */    
      
    protected function doCreateObject(array $raw): Space    
    {    
    $obj = new Space(    
    (int)$raw['id'],    
    $raw['name']    
    );    
      
    // ...    
    \`  
    `

Oczywiście takie zastosowanie komentarzy utrudnia znalezienie pojedynczego przykładu kodu. Mając to na uwadze zamieściłem w niniejszym archiwum plik o nazwie content.txt, zawierający spis przykładów. (Także i ten plik został wygenerowany automatycznie). Lista ta powinna ułatwić znalezienie konkretnego przykładu. Oto na przykład fragment pokazujący, jak znaleźć przykłady w rozdziale 13\. 
    
    `\`13.13:     
    src/r13/zestaw01/Mapper.php    
    13.14:     
    src/r13/zestaw01/SpaceMapper.php    
    13.15:     
    src/r13/zestaw01/SpaceMapper.php    
    13.16:     
    src/r13/zestaw01/SpaceMapper.php    
    13.17:     
    src/r13/zestaw01/Venue.php    
    13.18:     
    src/r13/zestaw03/Runner.php    
    13.19:     
    src/r13/zestaw03/ObjectWatcher.php    
    13.20:     
    src/r13/zestaw03/Mapper.php    
    13.21:     
    src/r13/zestaw01/SpaceMapper.php    
    \`  
    `

