<?php
require_once( 'woo/base/Registry.php' );
require_once( 'woo/base/Exceptions.php' );

class woo_controller_Request {
    private $appreg;
    private $properties;
    private $objects = array();
    private $feedback = array();
    private $lastCommand;

    function __construct() {
        $this->init();
        woo_base_RequestRegistry::setRequest($this );
    }

    function init() {
        if ( $_SERVER['REQUEST_METHOD'] ) {
            $this->properties = $_REQUEST;
            return;
        }
        foreach( $_SERVER['argv'] as $arg ) {
            if ( strpos( $arg, '=' ) ) {
                list( $key, $val )=explode( "=", $arg );
                $this->setProperty( $key, $val );
            }
        }
    }

    function getProperty( $key ) {
        return $this->properties[$key];
    }

    function setProperty( $key, $val ) {
        $this->properties[$key] = $val;
    }
    
    function __clone() {
        $this->properties = array();
    } 
    
    function addFeedback( $msg ) {
        array_push( $this->feedback, $msg );
    }
 
    function getFeedback( ) {
        return $this->feedback;
    }

    function getFeedbackString( $separator="\n" ) {
        return implode( $separator, $this->feedback );
    }

    function setObject( $name, $object ) {
        $this->objects[$name] = $object;
    }

    function getObject( $name ) {
        return $this->objects[$name];
    }

    function setCommand( woo_command_Command $command ) {
        $this->lastCommand = $command;
    }

    function getLastCommand() {
        return $this->lastCommand;
    }
}
?>
