<?php
require_once( "woo/command/Command.php" );
require_once( "woo/command/DefaultCommand.php" );

class woo_command_CommandResolver {
    private static $base_cmd;
    private static $default_cmd;

    function __construct() {
        if ( ! self::$base_cmd ) {
            self::$base_cmd = new ReflectionClass( "woo_command_Command" );
            self::$default_cmd = new woo_command_DefaultCommand();
        }
    }

    function getCommand( woo_controller_Request $request ) {
        $cmd = $request->getProperty( 'cmd' );
        if ( ! $cmd ) {
            return self::$default_cmd;
        }
        $filepath = "woo/command/$cmd.php";
        $classname = "woo_command_$cmd";
        if ( file_exists( $filepath ) ) {
            require_once( "$filepath" );
            if ( class_exists( $classname) ) {
                $cmd_class = new ReflectionClass($classname);
                if ( $cmd_class->isSubClassOf( self::$base_cmd ) ) {
                    return $cmd_class->newInstance();
                } else {
                    $request->addFeedback( "polecenie '$cmd' nie wchodzi w skad hierarchii Command" );
                }
            }
        }
        $request->addFeedback( "nie znaleziono polecenia '$cmd'" );
        return clone self::$default_cmd;
    }
}

?>
