<?php
abstract class Lesson {
    protected $duration;
    const     FIXED = 1;
    const     TIMED = 2;
    private   $costtype = 1;

    function __construct( $duration, $costtype=1 ) {
        $this->duration = $duration;
        $this->costtype = $costtype;
    }

    function cost() {
        switch ( $this->costtype ) {
            CASE self::TIMED :
                return (5 * $this->duration); 
                break;
            CASE self::FIXED :
                return 30;
                break;
            default:
                $this->costtype = self::FIXED;
                return 30;
        }
    }

    function chargeType() {
        switch ( $this->costtype ) {
            CASE self::TIMED :
                return "stawka godzinowa"; 
                break;
            CASE self::FIXED :
                return "stawka staa"; 
                break;
            default:
                $this->costtype = self::FIXED;
                return "stawka staa"; 
        }
    }

    // pozostae metody...
}

class Lecture extends Lesson {
    // implementacja waciwa dla wykadw... 
}

class Seminar extends Lesson {
    // implementacja waciwa dla seminariw... 
}

$lesson = new Seminar( 4, Lesson::TIMED );
$lesson = new Seminar( 4, Lesson::FIXED );
$lesson = new Seminar( 4, 33 );
print "Koszt lekcji: {$lesson->cost()}. Sposb rozliczania: {$lesson->chargeType()}\n";
?>
