<?php
require_once( 'ShopProduct.php' );

$prod_class = new ReflectionClass( 'CdProduct' );
$methods = $prod_class->getMethods();

foreach ( $methods as $method ) {
  print methodData( $method );
  print "\n----\n";
}

function methodData( ReflectionMethod $method ) {
  $details = "";
  $name = $method->getName();
  if ( $method->isUserDefined() ) {
    $details .= "$name to metoda definiowana przez uytkownika\n"; 
  }
  if ( $method->isInternal() ) {
    $details .= "$name to metoda wbudowana\n"; 
  }
  if ( $method->isAbstract() ) {
    $details .= "$name to metoda abstrakcyjna\n"; 
  }
  if ( $method->isPublic() ) {
    $details .= "$name jest metod publiczn\n"; 
  }
  if ( $method->isProtected() ) {
    $details .= "$name jest metod chronion (protected)\n"; 
  }
  if ( $method->isPrivate() ) {
    $details .= "$name jest metod prywatn\n"; 
  }
  if ( $method->isStatic() ) {
    $details .= "$name to metoda statyczna\n"; 
  }
  if ( $method->isFinal() ) {
    $details .= "$name to metoda finalna\n"; 
  }
  if ( $method->isConstructor() ) {
    $details .= "$name to konstruktor\n"; 
  }
  if ( $method->returnsReference() ) {
    $details .= "$name zwraca referencj (nie warto)\n"; 
  }
  return $details;
}

?>
