<?php
require_once('UserStore.php');
require_once('PHPUnit2/Framework/TestCase.php');


class UserStoreTest extends PHPUnit2_Framework_TestCase {
    private $store;

    public function setUp() {
        $this->store = new UserStore();
    }
    
    public function  testAddUser_IncompleteData() {
        $this->assertFalse(
            $this->store->addUser(  "jan nowak" ),
            "Zbyt maa liczba argumentw powinna wywoa bd"
        );
    }
 
    public function  testAddUser_ShortPass() {
        try { 
            $this->store->addUser(  "jan nowak", "jn@b.com", "ff" );
        } catch ( Exception $e ) { return; }
        $this->fail("Spodziewany wyjtek zbyt krtkiego hasa");
    }

    public function  testAddUser_success() {
        $this->assertTrue(
            $this->store->addUser(  "jan nowak", "jn@b.com", "12345" ),
            "Uytkownik dodany z poprawnymi argumentami, operacja powinna da warto true"
        );
    }

    public function  testGetUser() {
        $this->store->addUser(  "jan nowak", "jn@b.com", "12345" );
        $user = $this->store->getUser(  "jn@b.com" );
        $this->assertEquals( $user->getMail(), "jn@b.com" );
    }

}

?>
