<?php

require_once("woo/base/Registry.php");
require_once("woo/base/Exceptions.php");
require_once("woo/domain/Finders.php");
require_once("woo/controller/ApplicationHelper.php");

abstract class woo_mapper_Mapper implements woo_domain_Finder {
    protected static $DB; 
    function __construct() {
        if ( ! self::$DB ) { 
            self::$DB = woo_controller_ApplicationHelper::
                        instance()->DB( );
        }
    }

    function load( DB_Result $result ) {
        $array = $result->fetchRow( DB_FETCHMODE_ASSOC ); 
        if ( ! is_array( $array ) ) { return null; }
        if ( ! $array['id'] ) { return null; }
        $object = $this->loadArray( $array );
        return $object; 
    }

    function getFromMap( $id ) {
        return woo_domain_ObjectWatcher::exists
                ( $this->targetClass(), $id );
    }

    function addToMap( woo_domain_DomainObject $obj ) {
        return woo_domain_ObjectWatcher::add( $obj );
    }


    function find( $id ) {
        $old = $this->getFromMap( $id );
        if ( $old ) { return $old; }
        return $this->doFind( $id );
    }

    function loadArray( $array ) {
        $old = $this->getFromMap( $array['id']);
        if ( $old ) { return $old; }
        $obj = $this->doLoad( $array );
        $this->addToMap( $obj );
        $obj->markClean();
        return $obj;
    }

    function insert( woo_domain_DomainObject $obj ) {
        $this->doInsert( $obj );
    }

    function doStatement( $sth, $values ) {
        $db_result = self::$DB->execute( $sth, $values );
        if ( DB::isError( $db_result ) ) {
            throw new woo_base_DBException( $db_result );
        }
        return $db_result;
    }

    //protected abstract function update( woo_domain_DomainObject $object );
    protected abstract function doLoad( $array );
    protected abstract function doFind( $id );
    protected abstract function doInsert( woo_domain_DomainObject $object );
    protected abstract function targetClass();
}
