<?php
require_once( "woo/base/Registry.php" );

class woo_domain_ObjectWatcher {
    private $all = array();
    private $dirty = array();
    private $new = array();
    private $delete = array();
    private static $instance;

    private function __construct() { }

    static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new woo_domain_ObjectWatcher();
        }
        return self::$instance;
    }
 
    function globalKey( woo_domain_DomainObject $obj ) {
        $key = get_class( $obj ).".".$obj->getId();
        return $key;
    }
  
    static function add( woo_domain_DomainObject $obj ) {
        $inst = self::instance();
        $inst->all[$inst->globalKey( $obj )] = $obj;
    }

    static function exists( $classname, $id ) {
        $inst = self::instance();
        $key = "$classname.$id";
        return $inst->all[$key];
    }
 
    static function addDelete( woo_domain_DomainObject $obj ) {
        $self = self::instance();
        $self->delete[$self->globalKey( $obj )] = $obj;
    }


    static function addDirty( woo_domain_DomainObject $obj ) {
        $inst = self::instance();
        if ( ! $inst->new[$inst->globalKey( $obj )] ) {
            $inst->dirty[$inst->globalKey( $obj )] = $obj;
        }
    }

    static function addNew( woo_domain_DomainObject $obj ) {
        $inst = self::instance();
        $inst->new[$inst->globalKey( $obj )] = $obj;
    }

    static function addClean(woo_domain_DomainObject $obj ) {
        $self = self::instance();
        unset( $self->delete[$self->globalKey( $obj )] );
        unset( $self->dirty[$self->globalKey( $obj )] );
    }

    function performOperations() {
        foreach ( $this->dirty as $key=>$obj ) {
            print "aktualizuj {$obj->getName()}\n";
            $obj->finder()->update( $obj );
        }
        foreach ( $this->new as $key=>$obj ) {
            print "wstawiam {$obj->getName()}\n";
            $obj->finder()->insert( $obj );
        }
        $this->dirty = array();
        $this->new = array();
    } 

    function __destruct() {
        $this->performOperations();
    }
}
