<?php

class UnitException extends Exception {}

abstract class Unit {
    abstract function bombardStrength();

    function addUnit( Unit $unit ) {
        throw new UnitException( get_class($this)." to li" );
    }

    function removeUnit( Unit $unit ) {
        throw new UnitException( get_class($this)." to li" );
    }
}

class Archer extends Unit {
    function bombardStrength() {
        return 4;
    }
}

class LaserCannonUnit extends Unit {

    function bombardStrength() {
        return 44;
    }
}

class Army extends Unit {
    private $units = array();

    function addUnit( Unit $unit ) {
        foreach ( $this->units as $thisunit ) {
            if ( $unit === $thisunit ) {
                return;
            }
        }
        $this->units[] = $unit;
    }

    function removeUnit( Unit $unit ) {
        $units = array();
        foreach ( $this->units as $thisunit ) {
            if ( $unit !== $thisunit ) {
                $units[] = $thisunit;
            }
        }
        $this->units = $units;
    }

    function bombardStrength() {
        $ret = 0;
        foreach( $this->units as $unit ) {
            $ret += $unit->bombardStrength();
        }
        return $ret;
    }
}

// utworzenie armii
$main_army = new Army();

// wczenie do niej paru jednostek
$main_army->addUnit( new Archer() );
$main_army->addUnit( new LaserCannonUnit() );

// utworzenie nowej armii
$sub_army = new Army();

// zacig do nowej armii
$sub_army->addUnit( new Archer() );
$sub_army->addUnit( new Archer() );
$sub_army->addUnit( new Archer() );

// wcielenie drugiej armii do pierwszej
$main_army->addUnit( $sub_army );

// obliczenia siy ataku wykonywane automatycznie, w tle
print "Atak z si: {$main_army->bombardStrength()}\n";
