<?php

abstract class ApptEncoder {
    abstract function encode();
}

abstract class TtdEncoder {
    abstract function encode();
}

abstract class ContactEncoder {
    abstract function encode();
}

class BloggsApptEncoder extends ApptEncoder {
    function encode() {
        return "Dane spotkania zakodowane w formacie BloggsCal\n";
    }
}

class BloggsContactEncoder extends ContactEncoder {
    function encode() {
        return "Dane kontaktowe zakodowane w formacie BloggsCal\n";
    }
}

class BloggsTtdEncoder extends ApptEncoder {
    function encode() {
        return "Terminarz prac zakodowany w formacie BloggsCal\n";
    }
}

class MegaApptEncoder extends ApptEncoder {
    function encode() {
        return "Dane spotkania zakodowane w formacie MegaCal\n";
    }
}

abstract class CommsManager {
    abstract function getHeaderText();
    abstract function getApptEncoder();
    abstract function getTtdEncoder();
    abstract function getContactEncoder();
    abstract function getFooterText();
}

class BloggsCommsManager extends CommsManager {
    function getHeaderText() {
        return "Nagwek BloggsCal\n";
    }

    function getApptEncoder() {
        return new BloggsApptEncoder(); 
    }

    function getTtdEncoder() {
        return new BloggsTtdEncoder(); 
    }

    function getContactEncoder() {
        return new BloggsContactEncoder(); 
    }

    function getFooterText() {
        return "Stopka BloggsCal\n";
    }
}

$comms = new BloggsCommsManager();
print $comms->getHeaderText();
print $comms->getApptEncoder()->encode();
print $comms->getTtdEncoder()->encode();
print $comms->getContactEncoder()->encode();
print $comms->getFooterText();

?>
