<?php
require_once('UserStore.php');
require_once('Validator.php');
require_once('PHPUnit2/Framework/TestCase.php');


class ValidatorTest extends PHPUnit2_Framework_TestCase {
    private $validator;

    public function setUp() {
        $store = new UserStore();
        $store->addUser(  "jan nowak", "jn@b.com", "12345" );
        $this->validator = new Validator( $store );
    }

    public function testValidate_WrongPass() {
        $this->assertFalse( 
            $this->validator->validateUser( "jn@b.com", "ze" ) );
    }

    public function testValidate_CorrectPass() {
        $this->assertTrue( 
            $this->validator->validateUser( "jn@b.com", "12345" ) );
    }

}

?>
