<?php

require_once( "woo/base/Exceptions.php" );
require_once( "woo/mapper.php" );
require_once( "woo/mapper/Mapper.php" );
require_once( "woo/mapper/Collections.php" );
require_once( "woo/domain.php" );

class woo_mapper_VenueMapper extends woo_mapper_Mapper 
                             implements woo_domain_VenueFinder {

    function __construct() {
        parent::__construct();
        $this->selectAllStmt = self::$DB->prepare( 
                            "SELECT * FROM venue");
        $this->selectStmt = self::$DB->prepare( 
                            "SELECT * FROM venue WHERE id=?");
        $this->updateStmt = self::$DB->prepare( 
                            "UPDATE venue SET name=?, id=? WHERE id=?");
        $this->insertStmt = self::$DB->prepare( 
                            "INSERT into venue (name, id) 
                             values( ?, ?)");
    } 
    
    function doFind( $id ) {
        $result = $this->doStatement( $this->selectStmt, array( $id ) );
        return $this->load( $result ); 
    }

    function findAll( ) {
        $result = $this->doStatement( $this->selectAllStmt, array() );
        return new woo_mapper_VenueCollection( $result, $this );
    }

    protected function doLoad( $array ) {
        $obj = new woo_domain_Venue( $array['id'] );
        $obj->setname( $array['name'] );
        $space_mapper = new woo_mapper_SpaceMapper();
        $space_collection = $space_mapper->findByVenue( $array['id'] );
        $obj->setSpaces( $space_collection );
        $obj->markClean();
        return $obj;
    }

    protected function targetClass() {
        return "woo_domain_Venue";
    }

    protected function doInsert( woo_domain_DomainObject $object ) {
        $values = array( $object->getname(), $object->getid() ); 
        $this->doStatement( $this->insertStmt, $values );
    }
    
    public function newId() {
        return self::$DB->nextId('venue');
    }

    function update( woo_domain_DomainObject $object ) {
        $values = array( $object->getname(), $object->getid(), $object->getId() ); 
        $this->doStatement( $this->updateStmt, $values );
    }

    # wasne
    # 
}
