<?php

class CommandNotFoundException extends Exception {}

class CommandFactory {
    private static $dir = 'commands';

    function getCommand( $action='Default' ) {
        $class = UCFirst(strtolower($action))."Command";  
        $file = self::$dir."/$class.php";
        if ( ! file_exists( $file ) ) {
            throw new CommandNotFoundException( "nie mona znale pliku '$file'" );
        }
        require_once( $file );
        if ( ! class_exists( $class ) ) {
            throw new CommandNotFoundException( "nie mona znale klasy '$class'" );
        }
        $cmd = new $class();
        return $cmd;
    }
}

$controller = new Controller();
// imitacja obsugi dania uytkownika
$context = $controller->getContext();
$context->addParam('action', 'login' );
$context->addParam('username', 'bob' );
$context->addParam('pass', 'tiddles' );
$controller->process();

class Controller {
    private $context;
    function __construct() {
        $this->context = new CommandContext();
    }

    function getContext() {
        return $this->context;
    }

    function process() {
        $cmd = CommandFactory::getCommand( $this->context->get('action') );
        if ( ! $cmd->execute( $this->context ) ) {
            // obsuga bdu
        } else {
            print "all is well";
            // sukces
        }
    } 
}    




// ------------- elementy pomocnicze
class User{
    private $name;
    function __construct( $name ) {
        $this->name = $name;
    }
}

class ReceiverFactory {
    static function getMessageSystem() {
        return new MessageSystem();
    }
    static function getAccessManager() {
        return new AccessManager();
    }
}

class MessageSystem {
    function send( $mail, $msg, $topic ) {
        return true;
    }

    function getError() {
        return "nie robi zbiegowiska, nie ma tu nic do ogldania";
    }
}

class AccessManager {
    function login( $user, $pass ) {
        $ret = new User( $user );
        return $ret;
    }

    function getError() {
        return "nie robi zbiegowiska, nie ma tu nic do ogldania";
    }
}

class CommandContext {
    private $params = array();
    private $error = "";

    function __construct() {
        $this->params = $_REQUEST;
    }

    function addParam( $key, $val ) { 
        $this->params[$key]=$val;
    }

    function get( $key ) { 
        return $this->params[$key];
    }

    function setError( $error ) {
        $this->error = $error;
    }
    function getError() {
        return $this->error;
    }
}
/*
$context = new CommandContext();
$context->addParam( "username", "bob" );
$context->addParam( "pass", "tiddles" );
$cmd = new LoginCommand( new AccessManager() );
if ( ! $cmd->execute( $context ) ) {
    print "wystpi bd: ".$context->getError();
} else {
    print "udane logowanie\n";
    $user_obj = $context->get( "user" );
}
*/
