<?php
abstract class Lesson {
    private   $duration;
    private   $costStrategy;

    function __construct( $duration, CostStrategy $strategy ) {
        $this->duration = $duration;
        $this->costStrategy = $strategy;
    }

    function cost() {
        return $this->costStrategy->cost( $this );
    }

    function chargeType() {
        return $this->costStrategy->chargeType( );
    }

    function getDuration() {
        return $this->duration;
    }

    // pozostae metody...
}

class Lecture extends Lesson {
    // implementacja waciwa dla wykadw... 
}

class Seminar extends Lesson {
    // implementacja waciwa dla seminariw... 
}

abstract class CostStrategy {
    abstract function cost( Lesson $lesson );
    abstract function chargeType();
}

class TimedCostStrategy extends CostStrategy {
    function cost( Lesson $lesson ) {
        return ( $lesson->getDuration() * 5 );
    }
    function chargeType() {
        return "stawka godzinowa";
    }
}

class FixedCostStrategy extends CostStrategy {
    function cost( Lesson $lesson ) {
        return 30;
    }

    function chargeType() {
        return "stawka staa";
    }
}

$lessons[] = new Seminar( 4, new TimedCostStrategy() );
$lessons[] = new Lecture( 4, new FixedCostStrategy() );

foreach ( $lessons as $lesson ) {
    print "Koszt lekcji: {$lesson->cost()}. ";
    print "Sposb rozliczania: {$lesson->chargeType()}\n";
}

// wydruk:
// Koszt lekcji: 20. Sposb rozliczania: stawka godzinowa
// Koszt lekcji: 30. Sposb rozliczania: stawka staa

?>
