<?php
/**
 * @license   http://www.example.com Borsetshire Open License
 * @package   command
 */

/**
 * Hermetyzuje dane przekazywane do polece i pomidzy nimi.
 * Polecenia wymagaj rnych danych, zalenych od kontekstu.
 * Dlatego do wywoania metody {@link Command::execute()} klas
 * z hierarchii Command przekazywany jest zawsze 
 * obiekt klasy CommandContext method, zawierajcy dane dla
 * polecenia w postaci par klucz-warto. Klasa automatycznie
 * wyuskuje dane z globalnej zmiennej $_REQUEST.
 *
 * @package command
 * @author  Clarrie Grundie
 * @copyright 2004 Ambridge Technologies Ltd
 */

class CommandContext {
/**
 * Nazwa aplikacji.
 * Wykorzystywana dw komunikatach o bdach itp.
 * @var string
 */
    public $applicationName;

/**
 * Tablica par klucz-warto.
 * Caa klasa peni rol koperty dla tej tablicy.
 * @var array
 */
    private $params = array();

/**
 * Komunikat o bdzie.
 * @var string
 */
    private $error = "";

    function __construct( $appname ) {
        $this->params = $_REQUEST;
        $this->applicationName = $appname;
    }

    function addParam( $key, $val ) { 
        $this->params[$key]=$val;
    }

    function get( $key ) { 
        return $this->params[$key];
    }

    function setError( $error ) {
        $this->error = $error;
    }

    function getError() {
        return $this->error;
    }
}

?>
