<?php

abstract class woo_base_Registry {
    private function __construct() {} 
    abstract protected function get( $key );
    abstract protected function set( $key, $val );

}

class woo_base_RequestRegistry extends woo_base_Registry {
    private $values = array();
    private static $instance;

    static function instance() {
        if ( ! self::$instance ) { self::$instance = new self(); }
        return self::$instance;
    } 

    protected function get( $key ) {
        return $this->values[$key];
    }

    protected function set( $key, $val ) {
        $this->values[$key] = $val;
    }

    static function getRequest() {
        return self::instance()->get('request');
    }

    static function setRequest( woo_controller_Request $request ) {
        return self::instance()->set('request', $request );
    }
}

class woo_base_SessionRegistry extends woo_base_Registry {
    private static $instance;
    private function __construct() { 
        session_start();
    }

    static function instance() {
        if ( ! self::$instance ) { self::$instance = new self(); }
        return self::$instance;
    } 

    protected function get( $key ) {
        return $_SESSION[__CLASS__][$key];
    }

    protected function set( $key, $val ) {
        $_SESSION[__CLASS__][$key] = $val;
    }

    function setComplex( Complex $complex ) {
        return self::instance()->set('complex', $complex);
    }

    function getComplex( ) {
        return self::instance()->get('complex');
    }
}

class woo_base_ApplicationRegistry extends woo_base_Registry {
    private static $instance;
    private $freezefile = "data/applicationRegistry.txt";
    private $values = array();
    private $dirty = false;

    private function __construct() { 
        $this->reload();
    }

    static function instance() {
        if ( ! self::$instance ) { self::$instance = new self(); }
        return self::$instance;
    } 

    function __destruct() {
        if ( $this->dirty ) {
            $this->save();
        }
    }

    private function reload() {
        if ( ! file_exists( $this->freezefile ) ) { return false; }
        $serialized = file_get_contents( $this->freezefile, true );
        $array = unserialize( $serialized ); 
        if ( is_array( $array ) ) {
            if ( $this->dirty ) {
                $this->values = array_merge( $this->values, $values );
            } else {
                $this->values = $array;
            }
            return true;
        }
        return false;
    }

    private function save() {
        $frozen = serialize( $this->values ); 
        file_put_contents(  $this->freezefile, $frozen, 
                            FILE_USE_INCLUDE_PATH  );
        $self->dirty = false;
    }

    protected function get( $key ) {
        return $this->values[$key];
    }

    protected function set( $key, $val ) {
        $this->dirty = true;
        $this->values[$key] = $val;
    }

    static function isEmpty() {
        return empty( self::instance()->values );
    }

    static function getDSN() {
        return self::instance()->get('dsn');
    }

    static function setDSN( $dsn ) {
        return self::instance()->set('dsn', $dsn);
    }

    static function getControllerMap( ) {
        return self::instance()->get('cmap');
    }

    static function setControllerMap( woo_controller_ControllerMap $map ) {
        return self::instance()->set('cmap', $map);
    }

}

?>
