<?php

abstract class ApptEncoder {
    abstract function encode();
}

abstract class TtdEncoder {
    abstract function encode();
}

abstract class ContactEncoder {
    abstract function encode();
}

class BloggsApptEncoder extends ApptEncoder {
    function encode() {
        return "Dane spotkania zakodowane w formacie BloggsCal\n";
    }
}

class BloggsContactEncoder extends ContactEncoder {
    function encode() {
        return "Dane kontaktowe zakodowane w formacie BloggsCal\n";
    }
}

class BloggsTtdEncoder extends ApptEncoder {
    function encode() {
        return "Terminarz prac zakodowany w formacie BloggsCal\n";
    }
}

class MegaApptEncoder extends ApptEncoder {
    function encode() {
        return "Dane spotkania zakodowane w formacie MegaCal\n";
    }
}

abstract class CommsManager {
    const APPT    = 1;
    const TTD     = 2;
    const CONTACT = 3;
    abstract function getHeaderText();
    abstract function make( $flag_int );
    abstract function getFooterText();
}

class BloggsCommsManager extends CommsManager {
    function getHeaderText() {
        return "BloggsCal header\n";
    }

    function make( $flag_int ) {
        switch ( $flag_int ) {
            case self::APPT:
                return new BloggsApptEncoder();
            case self::CONTACT:
                return new BloggsContactEncoder();
            case self::TTD:
                return new BloggsTtdEncoder();
        } 
    }

    function getFooterText() {
        return "Stopka BloggsCal\n";
    }
}

$comms = new BloggsCommsManager();
print $comms->getHeaderText();
print $comms->make( CommsManager::APPT )->encode();
print $comms->make( CommsManager::TTD )->encode();
print $comms->make( CommsManager::CONTACT )->encode();
print $comms->getFooterText();

?>
