<?php
require_once( 'woo/base/Registry.php' );
require_once( 'woo/base/Exceptions.php' );
require_once( 'woo/controller/AppController.php' );
require_once( 'DB.php' );

// UWAGA - dostosowa ciek do konfiguracji...
set_include_path( ".:/home/triffid/htdocs/frontcontroller_eg/"
                   .get_include_path());

class woo_controller_ApplicationHelper {
    private static $instance;
    private $config = "data/woo_options.xml";

    private function __construct() {} 

    static function instance() {
        if ( ! self::$instance ) {
            self::$instance = new self();
        } 
        return self::$instance;
    }

    function init() {
        if ( ! woo_base_ApplicationRegistry::isEmpty() ) {
            return;
        }
        $this->getOptions();
    }

    private function getOptions() {
        $this->ensure( file_exists( $this->config  ), 
                            "Nie mona znale pliku opcji" );
        $options = @SimpleXml_load_file( $this->config );
        $this->ensure( $options instanceof SimpleXMLElement,
                            "Nie mona przeanalizowa pliku opcji" );
        $dsn = (string)$options->dsn; 
        $this->ensure( $dsn, "Brak DSN" );
        woo_base_ApplicationRegistry::setDSN( $dsn );

        $map = new woo_controller_ControllerMap(); 

        foreach ( $options->control->view as $default_view ) {
            $stat_str = trim($default_view['status']); 
            $status = woo_command_Command::statuses( $stat_str );
            $map->addView( 'default', $status, (string)$default_view );
        }

        foreach ( $options->control->command as $command_view ) {
            $command =  trim((string)$command_view['name'] );
            if ( $command_view->classalias ) {
                $classroot = trim((string)$command_view->classroot['name']);
                $map->addClassroot( $command, $classroot  );
            }
            if ( $command_view->view ) {
                $view =  trim((string)$command_view->view);
                $forward = trim((string)$command_view->forward);
                $map->addView( $command, 0, $view );
                if ( $forward ) {
                    $map->addForward( $command, 0, $forward );
                }
                foreach( $command_view->status as $command_view_status ) {
                    $view =  trim((string)$command_view_status->view);
                    $forward = trim((string)$command_view_status->forward);
                    $stat_str = trim($command_view_status['value']); 
                    $status = woo_command_Command::statuses( $stat_str );
                    if ( $view ) {
                        $map->addView( $command, $status, $view );
                    }
                    if ( $forward ) {
                        $map->addForward( $command, $status, $forward );
                    }
                }
            }
        }

        woo_base_ApplicationRegistry::setControllerMap( $map );
    }

    private function ensure( $expr, $message ) {
        if ( ! $expr ) {
            throw new woo_base_AppException( $message );    
        }
    }

    function DB() {
        $dsn = woo_base_ApplicationRegistry::getDSN(); 
        $this->ensure( $dsn, "Brak DSN" );
        if ( ! $this->db ) {
            $this->db = DB::connect( $dsn );
        }
        $this->ensure(  (! DB::isError( $this->db )), 
                        "Nie mona nawiza poczenia z baz danych" );    
        return $this->db;
    }

    function appController() {
        $map = woo_base_ApplicationRegistry::getControllerMap(); 
        $this->ensure( is_object($map), "Brak obiektu ControllerMap" );
        return new woo_controller_AppController( $map );
    }
}
?>
