<?php

abstract class ApptEncoder {
    abstract function encode();
}

class BloggsApptEncoder extends ApptEncoder {
    function encode() {
        return "Dane spotkania zakodowane w formacie BloggsCal\n";
    }
}

abstract class CommsManager {
    abstract function getHeaderText();
    abstract function getApptEncoder();
    abstract function getFooterText();
}

class BloggsCommsManager extends CommsManager {
    function getHeaderText() {
        return "Nagwek BloggsCal\n";
    }

    function getApptEncoder() {
        return new BloggsApptEncoder(); 
    }

    function getFooterText() {
        return "Stopka BloggsCal\n";
    }
}

$comms = new BloggsCommsManager();
$apptEncoder = $comms->getApptEncoder();
print $comms->getHeaderText();
print $apptEncoder->encode();
print $comms->getFooterText();
?>
