<?php
require_once("DB.php");

class Person {
    private $name;
    private $age;
    private $id = 0;

    function __construct( $name, $age ) {
        $this->name = $name;
        $this->age  = $age;
    }

    function setID( $id ) {
        $this->id = $id;
    }

    function getName() {
        return $this->name;
    }

    function getAge() {
        return $this->age;
    }
}

class PersonPersist {
    private $dsn;
    private $db_obj;
    private $fields = array( "name", "age" );

    function __construct( $dsn ) {
        $this->dsn = $dsn;
    }

    public function connect( ) {
        $this->db_obj = DB::connect($this->dsn);
        if ( DB::isError( $this->db_obj )) {
            throw new Exception("Bd poczenia z baz danych");
        }
    }

    public function insert( Person $person ) {
        if ( empty( $this->db_obj) ) {
            $this->connect();
        }
        $row = array();
        foreach( $this->fields as $fieldname ) {
            $method = "get{$fieldname}";
            $row[$fieldname] = $person->$method(); 
        }
        $row['id'] = $this->db_obj->nextId('persons_sequence');
        $insert_result = 
            $this->db_obj->autoExecute( 
            'persons', $row, DB_AUTOQUERY_INSERT );
        $person->setId( $row['id'] );
        return $row['id'];
    }
}

$person = new Person( 'bob', 44 );
try {
    $saver = new PersonPersist( "sqlite://./persons.db" );
    $saver->insert( $person );
} catch ( Exception $e ) {
    print $e->__toString();
}

?>
