<?php
class ShopProduct {
    public $numPages;
    public $playLength;
    public $title;
    public $producerMainName;
    public $producerFirstName;
    public $price;
    
    function __construct(   $title, $firstName, 
                            $mainName, $price, 
                            $numPages=0, $playLength=0 ) { 
        $this->title             = $title;
        $this->producerFirstName = $firstName;
        $this->producerMainName  = $mainName;
        $this->price             = $price;
        $this->numPages          = $numPages;
        $this->playLength        = $playLength;
    }

    function getProducer() {
        return "{$this->producerFirstName}".
               " {$this->producerMainName}";
    }

    function getSummaryLine() {
        $base  = "$this->title ( $this->producerMainName, ";
        $base .= "$this->producerFirstName )"; 
        return $base;
    }

    function getProductXml() {
        // pusta implementacja
    }
}

class CdProduct extends ShopProduct {
    function getPlayLength() {
        return $this->playLength;
    }
    
    function getSummaryLine() {
        $base  = "$this->title ( $this->producerMainName, ";
        $base .= "$this->producerFirstName )"; 
        $base .= ": czas nagrania - $this->playLength";
        return $base;
    }
}

class BookProduct extends ShopProduct {
    function getNumberOfPages() {
        return $this->numPages;
    }
 
    function getSummaryLine() {
        $base  = "$this->title ( $this->producerMainName, ";
        $base .= "$this->producerFirstName )"; 
        $base .= ": liczba stron - $this->numPages";
        return $base;
    }
}

$product1 = new BookProduct(    "Moja Antonia", "Willa", "Cather", 59.99, 300 );
$product2 =   new CdProduct(    "Exile on Coldharbour Lane", 
                                "The", "Alabama 3", 25.99, null, 60.33 );

print "Autor:         ".$product1->getProducer()."\n";
print "Liczba stron:  ".$product1->getNumberOfPages()."\n";
print "Wykonawca:     ".$product2->getProducer()."\n";
print "Czas nagrania: ".$product2->getPlayLength()."\n";

// Autor:         Willa Cather
// Liczba stron:  300
// Wykonawca:     The Alabama 3
// Czas nagrania: 60.33
?>
