<?php

// docza klas PhpIni
require_once('classes\PhpIni.php');

// tworzy egzemplarz obiektu PhpIni
$phpIni = new PhpIni(array('D:\\tlum\\kody\\Rozdzial5\\config\\'));

// definiuje rodowisko
$phpIni->setEnvironment('DEVELOPMENT');

// aplikuje wszystkie ustawienia z plikw .ini,
// zastpujc przy tym warto 'error_log' wasn wartoci
$phpIni->applySettings(array('error_log' => 'D:\logs\php_errors.txt'));

// wywietla informacj o biecym rodowisku
echo "Biece rodowisko: (" . $phpIni->getEnvironment() . "): "
    . $phpIni->getActiveSetting('description') . "\n";
    
// biece ustawienie 'error_log'
echo "Biece ustawienie 'error_log' dla tego rodowiska: "
    . $phpIni->getActiveSetting('error_log') . "\n";

// domylne ustawienie 'error_log' dla tego rodowiska (DEVELOPMENT)
echo "Domylne ustawienie 'error_log' w tym rodowisku: "
    . $phpIni->getDefaultSetting('error_log') . "\n";

// domylne ustawienie 'error_log' dla nieaktywnego rodowiska PRODUCTION
echo "Domylne ustawienie 'error_log' dla rodowiska Production: "
    . $phpIni->getDefaultSetting('error_log', 'PRODUCTION') . "\n";

?>