<?php
// ustawienia dziennikw i raportowania bdw dla rodowiska development
if (ENVIRONMENT == 'Development') {
    
    // poziom szczegowoci dziennika
    ini_set('error_reporting', 'E_ALL | E_STRICT');

    // wywietlanie bdw w przegldarce
    ini_set('display_errors', 'On');

    // wywietlanie bdw uruchamiania
    ini_set('display_startup_errors', 'On');

    // zapisywanie bdw do dziennika
    ini_set('log_errors', 'On');

    // brak limitu rozmiaru komunikatu bdu
    ini_set('log_errors_max_len', 0);

    // pokazuje wielokrotne wystpienia tego samego bdu
    ini_set('ignore_repeated_errors', 'Off');

    // pokazuje te same bdy z innych rde
    ini_set('ignore_repeated_source', 'Off');

    // nie ukazuje wyciekw pamici w trybie debugowania
    ini_set('report_memleaks', 'Off');

    // przechowuje ostatni bd w $php_errormsg
    ini_set('track_errors', 'On');

    // formatuje bdy jako HTML
    ini_set('html_errors', 'On');

    // bazowy adres dokumentacji PHP
    ini_set('docref_root', 'http://www.php.net/manual/pl/');

    // rozszerzenie pliku strony dokumentacji
    ini_set('docref_ext', '.php');

    // nie poprzedza bdw adnym cigiem tekstowym
    ini_set('error_prepend_string', '');

    // ani nic nie dopisuje po bdzie
    ini_set('error_append_string', '');

    // lokalizacja pliku dziennika
    ini_set('error_log', '/var/log/php_errors.txt');

// domylne ustawienia dziennikw i raportowania bdw
} else {
    // poziom szczegowoci dziennika
    ini_set('error_reporting', 'E_ERROR');

    // nie ukazuje bdw w przegldarce
    ini_set('display_errors', 'Off');

    // ukrywa bdu uruchomieniowe
    ini_set('display_startup_errors', 'Off');

    // zapisuje bdy w pliku dziennika
    ini_set('log_errors', 'On');

    // nie ogranicza rozmiaru komunikatw bdw
    ini_set('log_errors_max_len', 0);

    // ukazuje wielokrotne wystpienia tego samego bdu
    ini_set('ignore_repeated_errors', 'Off');

    // ukazuje te same bdy z rnych rde
    ini_set('ignore_repeated_source', 'Off');

    // nie wywietla informacji o wyciekach pamici
    ini_set('report_memleaks', 'Off');

    // przechowuje ostatni bd w $php_errormsg
    ini_set('track_errors', 'On');

    // formatuje bdy jako zwyky tekst
    ini_set('html_errors', 'Off');

    // cieka do dokumentacji nie jest potrzebna
    ini_set('docref_root', '');

    // rozszerzenie pliku dokumentacji nie potrzebne
    ini_set('docref_ext', '.php');

    // nie poprzedza komunikatw bdw niczym
    ini_set('error_prepend_string', '');

    // i nie dopisuje nic po nich
    ini_set('error_append_string', '');

    // lokalizacja pliku dziennika
    ini_set('error_log', '/var/log/php_errors.txt');
}
?>