<?php
/** 
 * @author Dirk Merkel <dirk@waferthin.com> 
 * @package WebServices
 * @subpackage Authentication
 * @copyright Waferthin Web Works LLC
 * @license http://www.gnu.org/copyleft/gpl.html dostpne na licencji GPL
 */
/** 
 * <i>Accountable</i> interfejs do uwierzytelniania
 * 
 * Kada klasa realizujca uwierzytelnianie <b>musi</b>
 * implementowa ten interfejs. Dziki temu sprawdzanie
 * czy uytkownik jest zalogowany, czy nie staje si
 * niemal trywialne
 *
 * @package WebServices
 * @subpackage Authentication
 * @author Dirk Merkel <dirk@waferthin.com> 
 * @version 0.2
 * @since r12
 */
interface Accountable
{
    const AUTHENTICATION_ERR_MSG = 'Bieca sesja nie jest skojarzona z adnym kontem
uytkownika. Sprbuj si zalogowa.';

    /**
     * Czy biecy uytkownik jest zalogowany?
     * 
     * Metoda ta odpowiada na pytanie
     * "Czy biecy uytkownik jest zalogowany?"
     * 
     * @access public
     * @return bool
     */
    public function isLoggedIn();

    /**
     * Zwraca informacje o koncie uytkownika
     * 
     * Metoda ta suy do pobierania konta skojarzonego
     * z biecym zalogowaniem. <b>Uwaga:</b> biecy
     * uytkownik nie musi by w tym celu zalogowany
     * 
     * @access public
     * @param string $user nazwa uytkownika konta
     * @return Account
     */
    public function getAccount($user = '');
}

?>
