<?php

class ProbeService
{
    // port do skanowania
    public $port = 80;

    // host do skanowania
    public $host = 'google.com';

    // odwzorowanie numerw portw na typowe nazwy usug
    public $serviceName = array(23  => 'telnet',
                                25  => 'smtp',
                                80  => 'http',
                                110 => 'pop3',
                                443 => 'https'
                                );
                                
    // maksymalna ilo testw na hosta, na port
    protected $maxProbes = null;
    
    // wielowymiarowa tablica przechowujca liczb testw
    // na hosta na port
    protected $probeCount = array();
    
    // konstruktor inicjalizuje maxProbes na 3
    public function __construct($maxProbes = 3)
    {
        $this->maxProbes = $maxProbes;
    }
    
    // sonduje hosta i port
    public function probe($host, $port)
    {
        // zachowuje hosta i port na potrzeby innych metod
        $this->host = $host;
        $this->port = $port;
        
        try {
            
            // pobiera list adresw IP skojarzonych z hostem
            $ipAddresses = $this->resolveHost();

            // przechodzi przez te adresy
            foreach ($ipAddresses as $ip) {
                
                // sprawdza limit sondowania
                if ($this->probeCount[$this->host][$this->port] < $this->maxProbes) {

                    // zwiksza licznik sond
                    $this->increasePortCount();

                    // port odpowiedzia
                    if ($this->tcpConnection()) {

                        echo "$this->host odpowiada na porcie $this->port.";

                        // prbuje znale usug odpowiadajc portowi
                        if (array_key_exists($this->port, $this->serviceName)) {
                            echo " Port ten jest zwykle skojarzony z usug {$this->serviceName[$this->port]}.\n";
                        } else {
                            echo " Niestety nie mona przypisa tego portu do adnej usugi.\n";
                        }
                        break;

                    // nie udao si nawiza poczenia
                    } else {
                        echo "Host $this->host nie odpowiada na porcie $this->port.\n";
                    }
                    
                // generuje wyjtek - przekroczenie maksymalnej iloci sondowa
                } else {
                    throw new Exception("Maksymalna ilo sondowa ($this->maxProbes) zostaa przekroczona dla hosta: $this->host na porcie $this->port.");
                }
            }

        // przechwytuje wyjtek i informuje uytkownika
        } catch (Exception $e) {
            exit("Nie udao si sondowa hosta $this->host:$this->port: {$e->getMessage()}");
        }
    }
    
    // wyszukuje adresy IP odpowiadajce danej nazwie hosta
    protected function resolveHost()
    {
        if ($ipAddresses = gethostbynamel($this->host)) {
            return $ipAddresses;
        } else {
            throw new Exception('Nie udao si znale hosta: ' . $this->host . '. Sprawd poczenie sieciowe lub poprawnoc nazwy.');
        }
    }
    
    // metoda ledzca poczenia z hostami i portami
    protected function increasePortCount()
    {
        // sprawdza, czy dana pozycja ju istnieje
        if (array_key_exists($this->host, $this->probeCount)
            && array_key_exists($this->port, $this->probeCount[$this->host])) {
                
                $this->probeCount[$this->host][$this->port]++;

            // tworzy now pozycj
            } else {
                $this->probeCount[$this->host][$this->port] = 1;
            }
    }
    
    // prbuje nazwiza poczenie poprzez gniazdo
    protected function tcpConnection()
    {
        // czy si
        $socket = fsockopen($this->host, $this->port, $errorNumber, $errorString, 30);

        // nie mona otworzy gniazda
        if (!$socket) {
            return FALSE;
        
        // udao si!
        } else {

            // zamyka poczenie i zwraca TRUE
            fclose($socket);

            return TRUE;
        }
    }
}

$probe = new ProbeService(3);
$probe->probe('yahoo.com', 80);

?>