<?php

require_once('D:\tlum\kody\Rozdzial7\interfaces\StringSearchable.php');

class BoyerMoore implements StringSearchable
{
    // stae klasy
    const CASE_SENSITIVE = true;
    const CASE_INSENSITIVE = false;
    
    // szukany podcig
    public $substring = 'null';
    public $originalSubstring = 'null';
    
    // bufor tekstowy, w ktrym ma nastpi wyszukiwanie
    public $buffer = '';
    public $originalBuffer = '';
    
    // tablica przeskokw stworzona na podstawie podcigu
    public $jumpTable = array();
    
    // tablica wynikw
    protected $results = array();

    public function __construct()
    {
        // specjalnie pozostawiono puste
    }

    public function __destruct()
    {
        // specjalnie pozostawiono puste
    }

    public function search($substring, $buffer, $caseSensitive = self::CASE_SENSITIVE)
    {
        // walidacja danych wejciowych
        if (!is_string($substring) || strlen($substring) < 1) {
            throw new Exception("Poszukiwany podcig musi by cigiem tekstowym skadajcym si co najmniej jednego znaku.");
        } elseif (!is_string($buffer) || strlen($buffer) < 1) {
            throw new Exception("Przeszukiwany bufor musi by cigiem tekstowym skadajcym si co najmniej jednego znaku.");
        } elseif (!is_bool($caseSensitive)) {
            throw new Exception("Trzeci argument funkcji " . __FUNCTION__ . " musi by wartoci logiczn.");
        }    

        // zeruje tablic wynikw
        $this->results = array();

        $this->substring = $substring;
        $this->originalSubstring = $substring;
        $this->buffer = $buffer;
        $this->originalBuffer = $buffer;
        
        // zamienia bufor i podcig na mae litery jeeli wyszikiwanie ma nie bra pod uwag
        // wielkoci liter
		
        if ($caseSensitive != self::CASE_SENSITIVE) {
            $this->substring = strtolower($this->substring);
            $this->buffer = strtolower($this->buffer);
        }
        
        // pobiera tablic przeskokw
        $this->deriveJumpTable();

        $currentCharacter = strlen($this->substring) - 1;
        $substringLength = strlen($this->substring);
        $bufferLength = strlen($this->buffer);

        while ($currentCharacter < $bufferLength) {

            for ($i = $substringLength - 1; $i >= 0; $i--) {

                // dopasowano znak, kontynuuj ...
                if ($this->buffer{($currentCharacter - $substringLength + $i + 1)} == $this->substring{$i}) {

                    // czy wszystkie znaki pasuj?
                    if ($i == 0) {
                        $this->results[] = $currentCharacter - $substringLength;
                        $currentCharacter += $this->getJumpLength($this->buffer{$currentCharacter});

                    } else {
                        continue;
                    }

                // nie pasuj, skocz dalej ...
                } else {
                    $currentCharacter += $this->getJumpLength($this->buffer{$currentCharacter});
                    break;
                }
            }
        }
        
        // zwraca true jeeli dopasowano cho jeden cig lub false, jeeli nie dopasowano
        return (sizeof($this->results) > 0);
    }
    
    // tworzy tabel wyszukiwania, ktra okrela, o ile znakw skoczy
    // do przodu jeeli biecy znak nie pasuje do wzorca
    protected function deriveJumpTable()
    {
        $maxJump = strlen($this->substring);

        // ptla poprzez litery 
        for ($i = strlen($this->substring) - 2; $i >= 0; $i--) {
            if (!array_key_exists($this->substring{$i}, $this->jumpTable)) {
                $this->jumpTable[$this->substring{$i}] = $maxJump - $i - 1;
            }
        }
    }
    
    // zwraca tablic przeskokw
    public function getJumpTable()
    {
        return $this->jumpTable;
    }
    
    // zwraca tablic wynikw
    public function getResults()
    {
        return $this->results;
    }
    
    // ile wystpie znaleziono?
    public function getResultsCount()
    {
        return sizeof($this->results);
    }
    
    // za pomoc tablicy przeskokw okrela o ile
    // przemieci si w buforze
    public function getJumpLength($character)
    {
        if (array_key_exists($character, $this->jumpTable)) {
            return $this->jumpTable[$character];
        } else {
            return strlen($this->substring);
        }
    }
}

?>