<?php

require_once 'c:\php\PEAR\PHPUnit\Framework.php';

require_once('D:\tlum\kody\Rozdzial7\interfaces\StringSearchable.php');
require_once('D:\tlum\kody\Rozdzial7\classes\Search\String\BoyerMoore.php');

class MultipleTest extends PHPUnit_Framework_TestCase
{
    protected $bm;
    
    protected function setUp()
    {
        // tworzy nową klasę przeszukującą ciągi
        $this->bm = new BoyerMoore();
    }
        
    /**
     * @dataProvider provider
     */
    public function testNumberOfMatches($buffer, $substring, $matches)
    {
        // przeprowadza wyszukiwanie
        $this->bm->search($substring, $buffer);

        // asercja zakładająca, że algorytm odnalazł
        // prawidłową liczbę wystąpień ciągu w buforze
        $this->assertEquals($matches, $this->bm->getResultsCount());
    }

    // Metoda ta udostępnia dane, jakie mają zostać
    // zastosowane przy wywołaniach metody testującej testNumberOfMatches()
    public function provider()
    {
        return array(
                    array('abcdeabcdabcaba', 'abc', 3),
                    array(<<<POEM
Na tapczanie siedzi leń,
nic nie robi cały dzień.

"O, wypraszam to sobie!
Jak to ja nic nie robię?
A kto siedzi na tapczanie?
A kto zjadł pierwsze śniadanie?
A kto dzisiaj pluł i łapał?
A kto się w głowę podrapał?
A kto dziś zgubił kalosze?
O - o! Proszę!"
POEM
                            , 'kto', 5)
                    );
    }

    // testowanie wyszukiwania bez rozróżniania wielkości liter
    public function testCaseInsensitive()
    {
        // pobiera tablicę danych z metody provider()
        $dataArr = $this->provider();
    
        // przeprowadza wyszukiwanie
        $this->bm->search('na tapczanie', $dataArr[1][0], BoyerMoore::CASE_INSENSITIVE);

        // asercja zakładająca, że algorytm odnalazł
        // prawidłową liczbę wystąpień ciągu w buforze
        $this->assertEquals(2, $this->bm->getResultsCount());
    }

}

?>