<?php

// definicja klasy reguy (tzw. sniff) musi implementowa
// interfejs PHP_CodeSniffer_Sniff
class ProjectStandard_Sniffs_Syntax_FullPhpTagsSniff implements PHP_CodeSniffer_Sniff
{
    // register zainteresowanie okrelonymi tokenami
    public function register()
    {
        return array(T_OPEN_TAG);
    }

    // kade wystpienie tokena jest przetwarzane za pomoc tej metody
    public function process(PHP_CodeSniffer_File $phpcsFile, $stackPtr)
    {
        $tokens = $phpcsFile->getTokens();

        // generuje ostrzeenie jeeli otwierajcy znacznik PHP nie jest pierwszym
        // tokenem w pliku
        if ($stackPtr != 0) {
            $phpcsFile->addWarning('Nic nie powinno poprzedza znacznika otwierajcego PHP.', $stackPtr);
        }
        
        // zgasza bd jeeli nie zastosowano penej wersji znacznika otwierajcego
        if ($tokens[$stackPtr]['content'] != '<?php') {
            $phpcsFile->addError('Dopuszczalne s tylko pene wersje znacznikw otwierajcych.', $stackPtr);
        }
        
        // wszystkie pliki musz mie znaczniki zamykajce
        if ($token[sizeof($tokens) - 1]['type'] != T_CLOSE_TAG) {
            $phpcsFile->addError('Wszystkie pliki musz koczy si znacznikiem zamykajcym PHP.', $stackPtr);
        }
    }
}

?> 
