<?php

class ClassNameConverter
{
    public static $classRootDir = array('www', 'sites', 'my_app', 'includes', 'classes');

    public static function makeClassName($absolutePath)
    {
        $platformClassRootDir = DIRECTORY_SEPARATOR .
                                implode(DIRECTORY_SEPARATOR, self::$classRootDir) .
                                DIRECTORY_SEPARATOR;

        // usuwa ciek prowadzc do katalogu bazowego klas
        $absolutePath = str_replace($platformClassRootDir, '', $absolutePath);

        // zastpuje separatory katalogw podkrelnikami
        // i wstawia wielk liter na pocztku kadego sowa
        $parts = explode(DIRECTORY_SEPARATOR, $absolutePath);
        
        foreach ($parts as $index => $value) {
            $parts[$index] = ucfirst(strtolower($value));
        }

        // czy podkrelnikami
        $absolutePath = implode('_', $parts);

        // usuwa rozszerzenie pliku
        $absolutePath = str_replace('.php', '', $absolutePath);

        return $absolutePath;
    }
}

$classNameExamples = array('\www\sites\my_app\includes\classes\logging\db\Mysql.php',
                            '\www\sites\my_app\includes\classes\logging\db\MysqlPatched.php',
                            '\www\sites\my_app\includes\classes\caching_lib\Memcached.php'
                            );

foreach ($classNameExamples as $path) {
    echo $path . ' zmienia si w ' . ClassNameConverter::makeClassName($path) . "\n";
}

?>
