<?php

require_once 'C:\php\PEAR\PHPUnit\Framework.php';

require_once('D:\tlum\kody\Rozdzial7\interfaces\StringSearchable.php');
require_once('D:\tlum\kody\Rozdzial7\classes\Search\String\BoyerMoore.php');

// klasy testujce maj nazwy pochodzce od nazw klas
// ktre testuj i s potomkami klasy PHPUnit_Framework_TestCase
class ExceptionsTest extends PHPUnit_Framework_TestCase
{
    protected $bm;
    
    protected function setUp()
    {
        // tworzy nowy obiekt klasy przeszukujcej cigi
        $this->bm = new BoyerMoore();
    }

    /** 
     * Testuje, czy w przypadku, gdy bufor, szukany cig
     * lub trzeci argument nie przejd walidacji, generowany jest wyjtek
     *
     * @dataProvider provider
     * @expectedException Exception 
     */
    public function testExceptions($buffer, $substring, $caseSensitive)
    {
        // wykonuje wyszukiwanie za pomoc naszego algorytmu
        $this->bm->search($substring, $buffer, $caseSensitive);
    }

    // metoda ta udostpnia dane, jakie maj by uywane przy wywoaniu
    // metody testNumberOfMatches()
    public function provider()
    {
        return array(
                    array('', 'znajd mnie', BoyerMoore::CASE_SENSITIVE), // pusty bufor
                    array(null, 'znajd mnie', BoyerMoore::CASE_SENSITIVE), // bufor ma warto null
                    array(array(), 'znajd mnie', BoyerMoore::CASE_SENSITIVE), // bufor jest tablic
                    array('przeszukaj mnie', '', BoyerMoore::CASE_SENSITIVE), // pusty szukany cig
                    array('przeszukaj mnie', null, BoyerMoore::CASE_SENSITIVE), // szukany cig ma warto null
                    array('przeszukaj mnie', array(), BoyerMoore::CASE_SENSITIVE), // szukany cig jest tablic
                    array('przeszukaj mnie', 'znajd mnie', 'co tam'), // trzeci argument jest niepoprawny
                    );
    }
}

?>