USE sample_db;

#
# Table structure for table 'php_category'
#

CREATE TABLE php_category (
   category varchar(30) NOT NULL,
   category_id varchar(15) NOT NULL,
   num_item int(5) NOT NULL,
   PRIMARY KEY (category_id)
);

#
# Dumping data for table 'php_category'
#

INSERT INTO php_category VALUES( 'General', '001', '2');
INSERT INTO php_category VALUES( 'Code Snippets', '005', '0');
INSERT INTO php_category VALUES( 'Articles', '004', '0');
INSERT INTO php_category VALUES( 'Portal', '002', '1');
INSERT INTO php_category VALUES( 'Applications', '003', '1');
INSERT INTO php_category VALUES( 'Books', '007', '1');
INSERT INTO php_category VALUES( 'Communities', '006', '0');
INSERT INTO php_category VALUES( 'Tutorials', '008', '10');
INSERT INTO php_category VALUES( 'Discussion Boards', '003001', '0');
INSERT INTO php_category VALUES( 'Chats', '003002', '3');
INSERT INTO php_category VALUES( 'Advertisements', '003003', '0');
INSERT INTO php_category VALUES( 'Shopping Carts', '003004', '0');
INSERT INTO php_category VALUES( 'File System', '003005', '0');
INSERT INTO php_category VALUES( 'Email', '003006', '0');
INSERT INTO php_category VALUES( 'Games', '003007', '1');
INSERT INTO php_category VALUES( 'Databases', '003008', '0');
INSERT INTO php_category VALUES( 'PHP General', '004001', '0');
INSERT INTO php_category VALUES( 'Functions', '004002', '0');
INSERT INTO php_category VALUES( 'Database Connectivity', '004003', '0');
INSERT INTO php_category VALUES( 'Session Management', '004004', '0');
INSERT INTO php_category VALUES( 'Extending PHP', '004005', '0');
INSERT INTO php_category VALUES( 'OOP', '004006', '0');
INSERT INTO php_category VALUES( 'PHP General', '005001', '0');
INSERT INTO php_category VALUES( 'Functions', '005002', '0');
INSERT INTO php_category VALUES( 'Database Connectivity', '005003', '1');
INSERT INTO php_category VALUES( 'Classes', '005004', '1');
INSERT INTO php_category VALUES( 'ETC', '005005', '0');
INSERT INTO php_category VALUES( 'Forums', '006001', '1');
INSERT INTO php_category VALUES( 'Mailing Lists', '006002', '0');
INSERT INTO php_category VALUES( 'Amazon', '007001', '1');
INSERT INTO php_category VALUES( 'Barnes & Nobles', '007002', '0');
INSERT INTO php_category VALUES( 'Publishers', '007003', '1');
INSERT INTO php_category VALUES( 'PHP General', '006002001', '0');
INSERT INTO php_category VALUES( 'Zend', '006002002', '0');
INSERT INTO php_category VALUES( 'Developers', '006002003', '0');
INSERT INTO php_category VALUES( 'Business', '009', '2');
INSERT INTO php_category VALUES( 'Reviews', '004007', '0');
INSERT INTO php_category VALUES( 'Generic Chats', '003002001', '0');
INSERT INTO php_category VALUES( 'PHP Chats', '003002002', '0');

#
# Table structure for table 'php_directory'
#

CREATE TABLE php_directory (
   url_id int(10) NOT NULL auto_increment,
   category_id varchar(15) NOT NULL,
   title varchar(150) NOT NULL,
   url varchar(150) NOT NULL,
   description text NOT NULL,
   registerdate date,
   hit int(5) NOT NULL,
   lastaccesstime timestamp(14),
   password varchar(20) binary,
   email varchar(100) NOT NULL,
   approved char(1) NOT NULL,
   PRIMARY KEY (url_id),
   UNIQUE url (url, category_id)
);

#
# Dumping data for table 'php_directory'
#

INSERT INTO php_directory VALUES( '2', '008', 'Beginning PHP', 'www.wrox.com/beginning.html', 'A great tutorial on PHP for novice programmers.', '2000-08-06', '2', '20000807175258', '.vBFuC/XAvCJA', '111', '1');
INSERT INTO php_directory VALUES( '4', '008', 'PHP MySQL Connectivity', 'www.wrox.com/mysql.html', 'A tutorial on PHP MySQL Connectivity.', '2000-08-06', '0', '20000807121308', '.vcIuwC90zXcw', '222', '1');
INSERT INTO php_directory VALUES( '1', '003007', 'Game Programming', 'www.phpgames.com', 'Fun and Games!', '2000-08-06', '3', '20000808013608', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '3', '008', 'A series of tutorials on file system', 'www.wrox.com/file.html', 'File System Tutorials.', '2000-08-06', '0', '20000807121348', '.vBFuC/XAvCJA', '111', '1');
INSERT INTO php_directory VALUES( '5', '008', 'Postgre Tutorial', 'www.wrox.com/Postgre.html', 'Postre Tutorial.', '2000-08-06', '0', '20000807121420', '.vuPSRSHFDcjw', '333', '1');
INSERT INTO php_directory VALUES( '6', '008', 'Sending Emails in PHP', 'www.wrox.com/email.html', 'Email tutorials.', '2000-08-06', '3', '20000807121452', '.v5yduNWrR8JM', '555', '1');
INSERT INTO php_directory VALUES( '7', '008', 'Creating Web Boards', 'www.wrox.com/board.html', 'Tutorials on discussion boards.', '2000-08-06', '0', '20000807121516', '.vHalmtJBzyMQ', '3', '1');
INSERT INTO php_directory VALUES( '8', '008', 'Object Oriented Programming in PHP', 'www.wrox.com/oop.html', 'Tutorials on OOP.', '2000-08-06', '0', '20000807121544', '.vYb1izGesU3Y', '1', '1');
INSERT INTO php_directory VALUES( '9', '008', 'Game Programming in PHP', 'www.wrox.com/game.html', 'Tutorials on Game Programming in PHP.', '2000-08-06', '0', '20000807121608', '.vHalmtJBzyMQ', '3', '1');
INSERT INTO php_directory VALUES( '10', '008', 'Data Types in PHP', 'www.wrox.com/data.html', 'Tutorials on working with PHP data types.', '2000-08-06', '0', '20000807121638', '.vHalmtJBzyMQ', '3', '1');
INSERT INTO php_directory VALUES( '11', '008', 'Creating Shopping Carts', 'www.wrox.com/cart.html', 'Tutorials on creating e-commerce applications in PHP.', '2000-08-06', '0', '20000807121721', '.vYb1izGesU3Y', '22', '1');
INSERT INTO php_directory VALUES( '13', '003002', 'A great chat site built in PHP', 'www.phpchat.com', 'Another PHP chat site!', '2000-08-06', '0', '20000807120522', '.vwK9w0qHJ98g', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '14', '003002', 'PHP Chat', 'www.bestphpchat.com', 'The greatest PHP chat site on the net!', '2000-08-06', '0', '20000807120356', '.v/bKRi/.bnfk', 'sdf', '1');
INSERT INTO php_directory VALUES( '15', '007001', 'Beginning PHP', 'www.amazon.com', 'A great book on PHP!', '2000-08-07', '2', '20000808014317', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '16', '009', 'PHP Biz!', 'www.phpbiz.com', 'PHP biz!', '2000-08-07', '0', '20000807120655', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '17', '005004', 'MIME Mailer', 'www.mimemailer.com', 'A MIME Mailer class.', '2000-08-07', '1', '20000807223022', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '18', '005003', 'MySQL Admin', 'www.mysqladmin.com', 'A MySQL admin script.', '2000-08-07', '0', '20000807120825', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '19', '006001', 'PHP Forum', 'www.phpforumcom', 'PHP Forum.', '2000-08-07', '0', '20000807120905', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '20', '001', 'PHP Home', 'www.php.net', 'PHP Homepage.', '2000-08-07', '0', '20000807121122', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '21', '001', 'Zend Website', 'www.zend.com', 'Zend!', '2000-08-07', '2', '20000807175303', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '22', '007003', 'Wrox Press Inc.', 'www.wrox.com', 'Wrox Press Inc.', '2000-08-07', '9', '20000808003129', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '23', '002', 'One and Only PHP Portal', 'www.phpportal.com', 'One and Only PHP Portal.', '2000-08-07', '0', '20000807121839', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '24', '003002', 'PHP Chat World!', 'www.phpchatworld.com', 'PHP Chat World! Come and get some!', '2000-08-07', '0', '20000807130014', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '25', '009', 'Buy and Sell PHP Scripts', 'www.buyandsellphpscripts.com', 'Make bucks out of your scripts!', '2000-08-07', '0', '20000807130559', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '26', '003', 'NeoQuest Communications, Inc.', 'www.neoqst.com', 'A great PHP showcase site!', '2000-08-07', '3', '20000812130908', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '27', '007', 'Professional PHP Programming', 'www.wrox.com', 'A great book on PHP for advanced programmers.', '2000-08-07', '2', '20000807175252', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');
INSERT INTO php_directory VALUES( '28', '001', 'Learning PHP!', 'www.learnphp.com', 'A great site where you can learn everything about PHP!', '2000-08-09', '0', '20000809191348', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '0');

GRANT ALL ON php_category.* TO phpuser IDENTIFIED BY 'phppass';
GRANT ALL ON php_directory.* TO phpuser IDENTIFIED BY 'phppass';