USE sample_db;

#
# Table structure for table 'php_category'
#

CREATE TABLE php_category (
   category varchar(30) NOT NULL,
   category_id varchar(15) NOT NULL,
   num_item int(5) NOT NULL,
   PRIMARY KEY (category_id)
);

#
# Dumping data for table 'php_category'
#

INSERT INTO php_category VALUES( 'Oglne', '001', '2');
INSERT INTO php_category VALUES( 'Fragmenty kodu', '005', '0');
INSERT INTO php_category VALUES( 'Artykuy', '004', '0');
INSERT INTO php_category VALUES( 'Portale', '002', '1');
INSERT INTO php_category VALUES( 'Aplikacje', '003', '1');
INSERT INTO php_category VALUES( 'Ksiki', '007', '1');
INSERT INTO php_category VALUES( 'Spoecznoci', '006', '0');
INSERT INTO php_category VALUES( 'Podrczniki i samouczki', '008', '10');
INSERT INTO php_category VALUES( 'Fora dyskusyjne', '003001', '0');
INSERT INTO php_category VALUES( 'Pogawdki', '003002', '3');
INSERT INTO php_category VALUES( 'Ogoszenia', '003003', '0');
INSERT INTO php_category VALUES( 'Karty zakupowe', '003004', '0');
INSERT INTO php_category VALUES( 'System plikw', '003005', '0');
INSERT INTO php_category VALUES( 'Poczta elektroniczna', '003006', '0');
INSERT INTO php_category VALUES( 'Gry', '003007', '1');
INSERT INTO php_category VALUES( 'Bazy danych', '003008', '0');
INSERT INTO php_category VALUES( 'PHP - oglnie', '004001', '0');
INSERT INTO php_category VALUES( 'Funkcje', '004002', '0');
INSERT INTO php_category VALUES( 'Obsuga baz danych', '004003', '0');
INSERT INTO php_category VALUES( 'Obsuga sesji', '004004', '0');
INSERT INTO php_category VALUES( 'Rozbudowywanie PHP', '004005', '0');
INSERT INTO php_category VALUES( 'OOP', '004006', '0');
INSERT INTO php_category VALUES( 'PHP - oglnie', '005001', '0');
INSERT INTO php_category VALUES( 'Funkcje', '005002', '0');
INSERT INTO php_category VALUES( 'Obsuga baz danych', '005003', '1');
INSERT INTO php_category VALUES( 'Klasy', '005004', '1');
INSERT INTO php_category VALUES( 'Inne', '005005', '0');
INSERT INTO php_category VALUES( 'Fora dyskusyjne', '006001', '1');
INSERT INTO php_category VALUES( 'Listy korespondencyjne', '006002', '0');
INSERT INTO php_category VALUES( 'Amazon', '007001', '1');
INSERT INTO php_category VALUES( 'Barnes & Nobles', '007002', '0');
INSERT INTO php_category VALUES( 'Wydawcy', '007003', '1');
INSERT INTO php_category VALUES( 'PHP - oglnie', '006002001', '0');
INSERT INTO php_category VALUES( 'Zend', '006002002', '0');
INSERT INTO php_category VALUES( 'Programici', '006002003', '0');
INSERT INTO php_category VALUES( 'Biznes', '009', '2');
INSERT INTO php_category VALUES( 'Przegldy informacyjne', '004007', '0');
INSERT INTO php_category VALUES( 'Oglne pogawdki', '003002001', '0');
INSERT INTO php_category VALUES( 'Rozmowy o PHP', '003002002', '0');

#
# Table structure for table 'php_directory'
#

CREATE TABLE php_directory (
   url_id int(10) NOT NULL auto_increment,
   category_id varchar(15) NOT NULL,
   title varchar(150) NOT NULL,
   url varchar(150) NOT NULL,
   description text NOT NULL,
   registerdate date,
   hit int(5) NOT NULL,
   lastaccesstime timestamp(14),
   password varchar(20) binary,
   email varchar(100) NOT NULL,
   approved char(1) NOT NULL,
   PRIMARY KEY (url_id),
   UNIQUE url (url, category_id)
);

#
# Dumping data for table 'php_directory'
#

INSERT INTO php_directory VALUES( '2', '008', 'PHP. Od podstaw', 'www.wrox.com/beginning.html', 
'Doskonay podrcznik powicony PHP przeznaczony dla pocztkujcych programistw.', '2000-08-06', '2', '20000807175258', '.vBFuC/XAvCJA', '111', '1');

INSERT INTO php_directory VALUES( '4', '008', 'Obsuga MySQL w PHP', 'www.wrox.com/mysql.html', 'Podrcznik dotyczcy obsugi baz danych z poziomu PHP', '2000-08-06', '0', '20000807121308', '.vcIuwC90zXcw', '222', '1');

INSERT INTO php_directory VALUES( '1', '003007', 'Programowanie gier', 'www.phpgames.com', 'Ciesz si i graj!', '2000-08-06', '3', '20000808013608', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '3', '008', 'Seria podrcznikw dotyczca systemu plikw', 'www.wrox.com/file.html', 'File System Tutorials.', '2000-08-06', '0', '20000807121348', '.vBFuC/XAvCJA', '111', '1');

INSERT INTO php_directory VALUES( '5', '008', 'PostgreSQL - podrcznik', 'www.wrox.com/Postgre.html', 'Podrcznik bazy danych PostgreSQL', '2000-08-06', '0', '20000807121420', '.vuPSRSHFDcjw', '333', '1');

INSERT INTO php_directory VALUES( '6', '008', 'Poczta elektroniczna w PHP', 'www.wrox.com/email.html', 'Podrcznik dotyczcy wykorzystania poczty elektronicznej.', '2000-08-06', '3', '20000807121452', '.v5yduNWrR8JM', '555', '1');

INSERT INTO php_directory VALUES( '7', '008', 'Tworzenie biuletynw', 'www.wrox.com/board.html', 'Podrcznik dotyczcy tworzenia i obsugi forw dyskusyjnych.', '2000-08-06', '0', '20000807121516', '.vHalmtJBzyMQ', '3', '1');

INSERT INTO php_directory VALUES( '8', '008', 'Programowanie obiektowe w PHP', 'www.wrox.com/oop.html', 'Podrcznik dotyczcy zasad programowania obiektowego.', '2000-08-06', '0', '20000807121544', '.vYb1izGesU3Y', '1', '1');

INSERT INTO php_directory VALUES( '9', '008', 'Programowanie gier PHP', 'www.wrox.com/game.html', 'Podrcznik dotyczcy sposobw programowania gier w PHP.', '2000-08-06', '0', '20000807121608', '.vHalmtJBzyMQ', '3', '1');

INSERT INTO php_directory VALUES( '10', '008', 'Typy danych w PHP', 'www.wrox.com/data.html', 'Podrcznik dotyczcy rnych typw danych dostpnych w PHP oraz zasad ich wykorzystania.', '2000-08-06', '0', '20000807121638', '.vHalmtJBzyMQ', '3', '1');

INSERT INTO php_directory VALUES( '11', '008', 'Tworzenie kart zakupowych', 'www.wrox.com/cart.html', 'Podrcznik dotyczcy tworzenia kart zakupowych i skryptw obsugi internetowych sklepw w PHP.', '2000-08-06', '0', '20000807121721', '.vYb1izGesU3Y', '22', '1');

INSERT INTO php_directory VALUES( '13', '003002', 'Tworzenie doskonaych witryn w PHP', 'www.phpchat.com', 'Kolejne informacje o wykorzystaniu PHP do tworzenia witryn WWW!', '2000-08-06', '0', '20000807120522', '.vwK9w0qHJ98g', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '14', '003002', 'Chat w PHP', 'www.bestphpchat.com', 'Najlepsza witryna chat-owa dostpna na Sieci!', '2000-08-06', '0', '20000807120356', '.v/bKRi/.bnfk', 'sdf', '1');

INSERT INTO php_directory VALUES( '15', '007001', 'PHP dla wszystkich', 'www.amazon.com', 'Wspaniaa ksika powicona PHP!', '2000-08-07', '2', '20000808014317', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '16', '009', 'PHP w biznesie!', 'www.phpbiz.com', 'PHP w zastosowaniach biznesowych!', '2000-08-07', '0', '20000807120655', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '17', '005004', 'MIME Mailer', 'www.mimemailer.com', 'Klasa suca do wysyania poczty elektronicznej w standardzie MIME.', '2000-08-07', '1', '20000807223022', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '18', '005003', 'MySQL Admin', 'www.mysqladmin.com', 'Skrypt do administrowania baz danych MySQL.', '2000-08-07', '0', '20000807120825', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '19', '006001', 'PHP Forum', 'www.phpforumcom', 'Forum dyskusyjne napisane w PHP.', '2000-08-07', '0', '20000807120905', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '20', '001', 'Witryna PHP', 'www.php.net', 'Gwna witryna powicona technologii PHP.', '2000-08-07', '0', '20000807121122', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '21', '001', 'Witryna Zend', 'www.zend.com', 'Zend!', '2000-08-07', '2', '20000807175303', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '22', '007003', 'Wrox Press Inc.', 'www.wrox.com', 'Wydawnictwo Wrox Press Inc.', '2000-08-07', '9', '20000808003129', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '23', '002', 'JedynieSuszny Portal PHP', 'www.phpportal.com', 'Jedyny portal PHP.', '2000-08-07', '0', '20000807121839', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '24', '003002', 'PHP Chat World!', 'www.phpchatworld.com', 'Pogawdki w PHP! Odwied witryn i sam zobacz!', '2000-08-07', '0', '20000807130014', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '25', '009', 'Kupuj i sprzedawaj skrypty PHP', 'www.buyandsellphpscripts.com', 'Zamie swoje skrypty PHP na pienidze!', '2000-08-07', '0', '20000807130559', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '26', '003', 'NeoQuest Communications, Inc.', 'www.neoqst.com', 'Doskonaa witryna powicona PHP!', '2000-08-07', '3', '20000812130908', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '27', '007', 'Professional PHP Programming', 'www.wrox.com', 'Doskonaa ksika powicona programowaniu w PHP dla zaawansowanych.', '2000-08-07', '2', '20000807175252', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '1');

INSERT INTO php_directory VALUES( '28', '001', 'Poznaj PHP!', 'www.learnphp.com', 'Doskonaa witryna na ktrej moesz si dowiedzie wszystkiego co dotyczy PHP!', '2000-08-09', '0', '20000809191348', '.vX/x4C0x/87k', 'wankyu@neoqst.com', '0');

GRANT ALL ON php_category.* TO phpuser IDENTIFIED BY 'phppass';
GRANT ALL ON php_directory.* TO phpuser IDENTIFIED BY 'phppass';