<?php
  $aPingCmd  = '/bin/ping -c 4';           // *nix
  $aTraceCmd = '/usr/sbin/traceroute -n';  // *nix
  
  // Zwraca redni czas wykonania polecenia ping
  function phpPing( $aAddress )
  {
    global $aPingCmd;
    
    $aTotalTime = 0.0;
    $aPingCount = 0;
    if ( $aFile = popen( "$aPingCmd $aAddress", "r" ) ) 
    {
      // Odczytanie danych z potoku
      while ( !feof( $aFile ) ) 
      {
        $aLine = fgets ( $aFile, 1024 );
        // Odszukanie danych o czasie
        $aPos  = strpos( $aLine, "time=" );
        if ( $aPos > 0 )
        {
          // Wykorzystanie zmiennoci typw zmiennych PHP 
          // do przekonwertowania czasu na liczb
          $aTime = substr( $aLine, $aPos + 5 ) * 1.0;
          $aTotalTime += $aTime;
          $aPingCount++;
        }
      }
      pclose( $aFile );
    }
    return $aTotalTime / $aPingCount;
  }
  
  function phpTrace( $aAddress )
  {
    global $aTraceCmd;

    $aTraceResults = "";
    if ( $aFile = popen( "$aTraceCmd $aAddress", "r" ) ) 
    {
      // Odczytanie wszystkich danych z potoku
      while ( !feof( $aFile ) ) 
      {
        $aLine = fgets ( $aFile, 1024 );
        $aTraceResults .= $aLine . "<br>";
      }
      pclose( $aFile );
    }
    
    return $aTraceResults;
  }
  
  function phpPageCheck( $aWebPage )
  {
    $aURL = parse_url( $aWebPage );
    $aResult = False;
    if ( $aURL["scheme"] == "http" )
    {
      $aRequest  = "HEAD {$aURL['path']} HTTP/1.0\r\n\r\n";
      $aSocket = fsockopen( $aURL["host"], 80 );
      if ( $aSocket )
      {
        fputs( $aSocket, $aRequest );
        while( !feof( $aSocket ) )
        {
          $aLine = fgets( $aSocket, 1024 );
          if ( substr( $aLine, 0, 4 ) == "HTTP" )
          {
            $aArray = explode( " ", $aLine );
            if ( ( $aArray[1] >= 200 ) && ( $aArray[1] < 300 ) )
            {
              $aResult = True;
            }
          }
        }
      }
    }
    
    return $aResult;
  }
?>
