<?php
  include( "./class.FastTemplate.php" );
  include( "./db_mysql.php" );  // db_mysql.inc o zmienionej nazwie
  // tworzenie klasy obsugi bazy danych dla aplikacji
  class genapps_db extends DB_Sql
  {
    var $Host      = "localhost"; 
    var $Database  = "mydb"; 
    var $User      = "root"; 
    var $Password  = "root";
  }
  // katalog dla plikw wynikowych
  $aPath = "./dns_output";

  $tpl  = new FastTemplate( "." );
  $tpl->define( array( named_main    => "named_primary.tpl",
                       named_zones   => "named_secondary.tpl",
                       named_slaves  => "named_slaves.tpl",
                       dns_main      => "dns_primary.tpl",
                       dns_cnames    => "dns_secondary.tpl",
                       dns_nservers  => "dns_nservers.tpl" ));
  // pobierz list serwerw nazw i zapamitaj do pniejszego wykorzystania
  $aNSDB = new genapps_db(); 
  $aSQL  = "select * from NameServers"; 
  $aNSDB->query( $aSQL ); // pobierz wszystkie dane strefy
  $aDB  = new genapps_db();
  $aSQL =  "select A.name, A.cname_list, A.incl_zone_file, B.name as soa_server, C.name as ";
  $aSQL .= "mail_server, D.value as ip_address from Domains A, SOAServers B, ";
  $aSQL .= "MailServers C, IPAddressess D where ( A.soa_server_id = B.soa_server_id ) ";
  $aSQL .= "and ( A.mail_server_id = C.mail_server_id ) and ";
  $aSQL .= "( A.ip_address_id = D.ip_address_id )"; 
  $aDB->query( $aSQL ); 

  while ( $aDB->next_record() )
  {
    $aDomainName   = strtolower( $aDB->f( "name" ) );
    $aCNames       = $aDB->f( "cname_list" );
    $aSoaServer    = $aDB->f( "soa_server" ) ;
    $aMailServer   = $aDB->f( "mail_server" );
    $aIPAddress    = $aDB->f( "ip_address" ); 
    $aInclZoneFile = $aDB->f( "incl_zone_file" ); 
    $tpl->assign( array( DOMAIN        => $aDomainName,
                         ADMINISTRATOR => "admin." . $aSoaServer,
                         SERIAL        => date( "Ymd" ) . "00",
                         MAIL_SERVER   => $aMailServer,
                         SOA_SERVER    => $aSoaServer,
                         IPADDRESS     => $aIPAddress,
                         CRLF          => "\n" ) );
    /* nazwy hostw (rekordy CNAME) s przechowywane w licie
    rozdzielanej przecinkami w bazie danyche. Dzielenie listy
    i tworzenie linii dla kadego elementu */
    $tpl->clear( CNAME_RECORDS );
    $aCNameList    = explode( ",", $aCNames );
    foreach( $aCNameList as $aCName )
    {
      $aCName = trim( $aCName );
      $tpl->assign( array( CNAME => $aCName ) );
      $tpl->parse( CNAME_RECORDS, ".dns_cnames");
    }
    // dodanie linii serwerw nazw do pliku strefy
    $tpl->clear( NAMESERVERS );
    $aNSDB->seek( 0 ) ;
    while ( $aNSDB->next_record() )
    {
      $tpl->assign( array( NAMESERVER => $aNSDB->f( "name" )) );
      $tpl->parse( NAMESERVERS, ".dns_nservers" ); 
    }
    $aDomainFile = $aDomainName . ".db";
    /* plik strefy jest tworzony tylko wtedy, gdy pole 'incl_zone_file'
    w bazie danych ma warto '!'
    */
    if ( $aInclZoneFile == "1" )
    {
      $tpl->parse(  DNS_MAIN, "dns_main");
      $aFile = fopen( "$aPath/$aDomainFile", "w"  ); 
      fwrite( $aFile, $tpl->fetch( DNS_MAIN ) ); 
      fclose( $aFile );
      print ("Plik domeny '$aDomainFile' zosta utworzony\n" );
    }
    /* dodanie bicej nazwy domeny do gwnego i pomocniczego pliku 
    konfiguracyjnego */
    $tpl->assign( array( DOMAIN_FILE => $aDomainFile ) ); 
    $tpl->parse( ZONES, '.named_zones' ); 
    $tpl->parse( SLAVES, '.named_slaves' );
  }
  $tpl->parse( NAMED_CONF, 'named_main' ); 
  $aFile = fopen( "$aPath/named.conf", "w" ); 
  fwrite( $aFile, $tpl->fetch( NAMED_CONF ) );
  fclose( $aFile );
  print( "Gwny plik 'named.conf' utworzony\n" ); 
  $aFile = fopen( "$aPath/named.slave", "w" ); 
  fwrite( $aFile, $tpl->fetch( SLAVES ) ); 
  fclose( $aFile );
  print( "Plik domeny 'named.slave' utworzony\n" ); 
?>