
#include "php.h"
#include "php_ini.h"
#include "php_fin_funcs.h"

/* If you declare any globals in php_fin_funcs.h uncomment this:
ZEND_DECLARE_MODULE_GLOBALS(fin_funcs)
*/

/* True global resources - no need for thread safety here */
static int le_fin_funcs;

/* Every user visible function must have an entry in fin_funcs_functions[].
*/
function_entry fin_funcs_functions[] = {
  PHP_FE(confirm_fin_funcs_compiled,  NULL)    /* For testing, remove later. */
  PHP_FE(fin_mpmt,  NULL)
  PHP_FE(fin_total,  NULL)
  PHP_FE(fin_table,  NULL)
  {NULL, NULL, NULL}  /* Must be the last line in fin_funcs_functions[] */
};

zend_module_entry fin_funcs_module_entry = {
  "fin_funcs",
  fin_funcs_functions,
  PHP_MINIT(fin_funcs),
  PHP_MSHUTDOWN(fin_funcs),
  PHP_RINIT(fin_funcs),    /* Replace with NULL if there's nothing to do at request start */
  PHP_RSHUTDOWN(fin_funcs),  /* Replace with NULL if there's nothing to do at request end */
  PHP_MINFO(fin_funcs),
  STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_FIN_FUNCS
ZEND_GET_MODULE(fin_funcs)
#endif

/* Remove comments and fill if you need to have entries in php.ini
PHP_INI_BEGIN()
PHP_INI_END()
*/

PHP_MINIT_FUNCTION(fin_funcs)
{
/* Remove comments if you have entries in php.ini
  REGISTER_INI_ENTRIES();
*/
  return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(fin_funcs)
{
/* Remove comments if you have entries in php.ini
  UNREGISTER_INI_ENTRIES();
*/
  return SUCCESS;
}

/* Remove if there's nothing to do at request start */
PHP_RINIT_FUNCTION(fin_funcs)
{
  return SUCCESS;
}

/* Remove if there's nothing to do at request end */
PHP_RSHUTDOWN_FUNCTION(fin_funcs)
{
  return SUCCESS;
}

PHP_MINFO_FUNCTION(fin_funcs)
{
  php_info_print_table_start();
  php_info_print_table_header(2, "fin_funcs support", "enabled");
  php_info_print_table_end();

  /* Remove comments if you have entries in php.ini
  DISPLAY_INI_ENTRIES();
  */
}

/* Remove the following function when you have succesfully modified config.m4
   so that your module can be compiled into PHP, it exists only for testing
   purposes. */

/* Every user-visible function in PHP should document itself in the source */
/* {{{ proto string confirm_fin_funcs_compiled(string arg)
   Return a string to confirm that the module is compiled in */
PHP_FUNCTION(confirm_fin_funcs_compiled)
{
  zval **arg;
  int len;
  char string[256];

  if (ZEND_NUM_ARGS() != 1 || zend_get_parameters_ex(1, &arg) == FAILURE) {
    WRONG_PARAM_COUNT;
  }

  convert_to_string_ex(arg);

  len = sprintf(string, "Congratulations, you have successfully modified ext/fin_funcs/config.m4, module %s is compiled into PHP", Z_STRVAL_PP(arg));
  RETURN_STRINGL(string, len, 1);
}
/* }}} */
/* The previous line is meant for emacs, so it can correctly fold and unfold
   functions in source code. See the corresponding marks just before function
   definition, where the functions purpose is also documented. Please follow
   this convention for the convenience of others editing your code.
*/

/* {{{ proto double fin_mpmt(double principle, double interest, double length)
    */
PHP_FUNCTION(fin_mpmt)
{
  zval **principle_arg, **interest_arg, **length_arg;
  double principle;
  double interest;
  double length;
  double aRetVal;

  if (ZEND_NUM_ARGS() != 3 || zend_get_parameters_ex(3, &principle_arg, &interest_arg, &length_arg) == FAILURE){
    WRONG_PARAM_COUNT;
  }

  convert_to_double_ex(principle_arg);
  principle = Z_DVAL_PP(principle_arg);
  convert_to_double_ex(interest_arg);
  interest = Z_DVAL_PP(interest_arg);
  convert_to_double_ex(length_arg);
  length = Z_DVAL_PP(length_arg);
  aRetVal = _fin_mpmt( principle, interest, length );
  RETVAL_DOUBLE( aRetVal );
}
/* }}} */

/* {{{ proto double fin_total(double principle, double interest, double length)
    */
PHP_FUNCTION(fin_total)
{
  zval **principle_arg, **interest_arg, **length_arg;
  double principle;
  double interest;
  double length;
  double aRetVal;

  if (ZEND_NUM_ARGS() != 3 || zend_get_parameters_ex(3, &principle_arg, &interest_arg, &length_arg) == FAILURE){
    WRONG_PARAM_COUNT;
  }

  convert_to_double_ex(principle_arg);
  principle = Z_DVAL_PP(principle_arg);
  convert_to_double_ex(interest_arg);
  interest = Z_DVAL_PP(interest_arg);
  convert_to_double_ex(length_arg);
  length = Z_DVAL_PP(length_arg);
  aRetVal = _fin_total( principle, interest, length );
  RETVAL_DOUBLE( aRetVal );
}
/* }}} */

/* {{{ proto array fin_table(double principle, double interest, double length)
    */
PHP_FUNCTION(fin_table)
{
  zval **principle_arg, **interest_arg, **length_arg;
  double principle;
  double interest;
  double length;
  double *pIntPmts;
  int n, nIndex;

  if (ZEND_NUM_ARGS() != 3 || zend_get_parameters_ex(3, &principle_arg, &interest_arg, &length_arg) == FAILURE){
    WRONG_PARAM_COUNT;
  }

  convert_to_double_ex(principle_arg);
  principle = Z_DVAL_PP(principle_arg);
  convert_to_double_ex(interest_arg);
  interest = Z_DVAL_PP(interest_arg);
  convert_to_double_ex(length_arg);
  length = Z_DVAL_PP(length_arg);
 n = (int)length * 12;
 pIntPmts = emalloc( sizeof( double ) * n );
 _fin_table( principle, interest, length, pIntPmts );
 if (array_init(return_value)== FAILURE )
 {
   php_error( E_ERROR, "fin_table: nie udao si utworzy tablicy");
 }
 else
 {
   for ( nIndex = 0; nindex < n; nIndex++ )
     add_next_index_double( return_value, pIntPmts[nIndex]);
 }
 efree( pIntPmts );
}
/* }}} */


