/*
   _fin_mpmt:
   oblicza miesiczn spat kredytu na podstawie
   kwoty kredytu (p), oprocentowania (i) oraz czasu (l)
*/
double _fin_mpmt (double p, double i, double l)
{
  double j;
  double n;
  j = i / (12 * 100);
  n = l * 12;
  return ( p* ( j/( 1 - (pow(( 1+j ), (n * -1))))));
}
/*
  _fin_total:
  oblicza cakowit kwot spat w czasie trwania kredytu
  na podstawie kwoty kredytu (p), oprocentowania (i) i czasu (l)
*/
double _fin_total (double p, double i, double l)
{
  return _fin_mpmt( p, i, l) * l * 12;
}
/*
  _fin_table:
  oblicza miesiczne odsetki uywane w planie amortyzacji dla kredytw na podstawie kwoty (p), oprocentowania (i) i czasu (l)
*/
void _fin_table ( double p, double i, double l, double *pIntPmt)
{
  double n, m, h, q, j, c;
  int    nIndex;
  j = i / (12 * 100);
  n = l * 12;
  q = p;
  m = _fin_mpmt( p, i, l );
  for (nIndex = 0; nIndex < n; nIndex++ )
  {
    h = q * j;
    c = m - h;
    q = q - c;
    pIntPmt[nIndex] = h;
  }
  return ;
}
